library(RProtoBuf)
setwd("/home/eamon/projects/noro/2012-11-23/EpiGLM/inst/simo/")
readProtoFiles("../proto/simo.proto")

put_input <- function(path, typecode=1:2,
                      initial_cases=matrix(1, 2, 2),
                      susceptibles=matrix(30, 2, 2),
                      proportionalities=matrix(c(.001, .005), 2, 2, byrow=TRUE),
                      latent_periods=matrix(1, 2, 2), max_time=100,
                      maxinftime=matrix(c(-1L, 1L), 2, 2, byrow=TRUE),
                      alphas=matrix(3, 2, 2), betas=matrix(.67, 2, 2),
                      nreps=2){
  s <- new(simo.SimSet)
  for(i in 1:nrow(initial_cases)){
    p <- new(simo.SimInput)
    p$type <- typecode
    p$max_time <- max_time
    p$initial_cases <- initial_cases[i,]
    p$susceptibles <- susceptibles[i,]
    p$proportionalities <- proportionalities[i,]
    p$latent_periods <- latent_periods[i,]
    p$alphas <- alphas[i,]
    p$betas <- betas[i,]
    p$maxinftime <- maxinftime[i,]
    replicate(nreps, s$add("siminput", p))
  }
  s$serialize("simo-in.pb")
}

get_output <- function(path="simo-out.pb") {
  con <- file(path, open="rb")
  message <- read(simo.SimOutput, con)
  close(con)
  with(message, data.frame(outbreak_id, type, latent_start, infective_start,
                           isolated_start, recovered_start))
}

run_sim <- function(...){
  put_input(...)
  #system(system.file(file.path("simo", "simo.py"), package="EpiGLM"))
  system("./simo.py")
  get_output()
}
