function showStack (R, G, B, varargin)

    %% find out which channels are present
    Nchannel=[0 0 0];
    if (~isempty(R))
        Nslice=size(R,3); Sx=size(R,1); Sy=size(R,2);
        Nchannel(1)=1;
    end
    if (~isempty(G))
        Nslice=size(G,3); Sx=size(G,1); Sy=size(G,2);
        Nchannel(2)=1;
    end
    if (~isempty(B))
        Nslice=size(B,3); Sx=size(B,1); Sy=size(B,2);
        Nchannel(3)=1;
    end
    
    if sum(Nchannel)==0
        fprintf('All channels are empty!\n');
        return;
    end
    
    %% clear those channels that are empty
    if (isempty(R))
        R=zeros(Sx,Sy,Nslice);
    end
    if (isempty(G))
        G=zeros(Sx,Sy,Nslice);
    end
    if (isempty(B))
        B=zeros(Sx,Sy,Nslice);
    end
    
    z=round(Nslice/2);
    chn=0;
    cont=1;

    xrange=[0 Sy];
    yrange=[0 Sx];
    fac=1;
    
    plotPoints=0;
    plotROI=0;
    
    % parse all the input arguments
    for n=1:2:length(varargin)
        if strcmpi(varargin{n}, 'points');
            plotPoints=1;
            pointXYZ=varargin{n+1};
        end
        if strcmpi(varargin{n}, 'roi');
            plotROI=1;
            roiXY=varargin{n+1};
        end
    end
    
    while cont==1
        
        if chn==0
            im=makeRGB( mat2gray(R(:,:,z)), mat2gray(G(:,:,z)), mat2gray(B(:,:,z)) );
        else
            if chn==1
                im=mat2gray(R(:,:,z));
            elseif chn==2
                im=mat2gray(G(:,:,z));
            elseif chn==3
                im=mat2gray(B(:,:,z));
            end
        end

        clf;
        imshow(im, 'InitialMagnification', 400);
        xlim(xrange);
        ylim(yrange);
        title(sprintf('z=%d',z));
        
        % plot points, if necessary
        if plotPoints==1
            q=find(round(pointXYZ(:,3))==z);
            hold on;
            plot(pointXYZ(q,1),pointXYZ(q,2), 'oy');
            hold off;
        end

        % plot ROI, if necessary
        if plotROI==1
            hold on;
            plot(roiXY(:,1)-2,roiXY(:,2)-2, '--y');
            hold off;
        end

        %% get keyboard input and process
        [x,y,but]=ginput(1);
        
        if but==27
            % 'ESC', quit
            cont=0;
        elseif but==28 || but==31
            % 'RIGHT', 'UP', move up through stack
            
            % find step size
            dz=1;
            if but==31
                dz=5
            end
            % change z coordinate
            z=z-dz;
            if z<1
                z=1;
            end
        elseif but==29 || but==30
            % 'LEFT', 'DOWN', move down through stack
            
            % find step size
            dz=1;
            if but==30
                dz=5
            end
            % change z coordinate
            z=z+dz;
            if z>Nslice
                z=Nslice;
            end
        elseif but==44 || but==46 || but==47 || but==39
            % '<','>','?','"', switch channel1, channel2, channel3 or
            % superposition of all three, respectively
            
            if but==44
                if Nchannel(1)==1
                    chn=1;
                end
            elseif but==46
                if Nchannel(2)==1
                    chn=2;
                end
            elseif but==47
                if Nchannel(3)==1
                    chn=3;
                end
            elseif but==39
                chn=0;
            end
            
            chn
            
        elseif but==43
            % '+', zoom in
            
            fac=fac*1.25;
            xzoom=x;
            yzoom=y;
            xrange=[xzoom-Sy/(2*fac) xzoom+Sy/(2*fac)];
            yrange=[yzoom-Sx/(2*fac) yzoom+Sx/(2*fac)];
            
        elseif but==42
            % '*', zoom in on region
            
            rect=getrect;
            fac=(Sy/rect(3)+Sx/rect(4))/2;
            xrange=[rect(1) rect(1)+rect(3)];
            yrange=[rect(2) rect(2)+rect(4)];
            
        elseif but==45
            % '-', zoom out
            
            fac=fac/1.25;
            if fac>1
                xzoom=x;
                yzoom=y;
                xrange=[xzoom-Sy/(2*fac) xzoom+Sy/(2*fac)];
                yrange=[yzoom-Sx/(2*fac) yzoom+Sx/(2*fac)];
            else
                fac=1;
                xrange=[0 Sy];
                yrange=[0 Sx];
            end
        end
    end
    
    close(gcf)
end