function plot2DmRNAfig(Pnp,R,G,B)

% number of pixels per cell for Pnp, Pnpx, Pnpxx
S(1).s=[4 4 4 4 4];
S(2).s=[2 2 2 2 2 2 2 2 2 2];
S(3).s=[2 2 1 1 1 1 1 1 1 1 1 1 1 1 2 2];

imshow(makeRGB(R,G,B), 'Ini', 1200)

hold on;
y=0.5;
for p=1:length(Pnp)
    % draw vertical lines
    s=0.5;
    for j=1:length(S(p).s)-1
        s=s+S(p).s(j);
        plot([s s], y+[0 length(Pnp(p).n)], '-', 'color', 0.99*[1 1 1]);
    end
    
    % draw vertical lines separating lineages
    s=0.5;
    for j=1:length(S(1).s)-1
        s=s+S(1).s(j);
        plot([s s], y+[0 length(Pnp(p).n)], '-', 'color', 0.99*[1 1 1], 'linewidth', 2);
    end

    % draw horizontal lines separating the different bins
    for j=1:length(Pnp(p).n)-1
        plot(0.5+[0 4*5], (y+j)*[1 1], ':', 'color', 0.99*[1 1 1]);
    end
    % draw horizontal line separating different stages
    y=y+length(Pnp(p).n);
    plot(0.5+[0 4*5], [y y], '-', 'color', 0.99*[1 1 1], 'linewidth', 2);
end
hold off;

lbl=4:8;
for i=1:length(lbl)
    text(1.5+4*(i-1),-0.1,sprintf('P%d.p',lbl(i)), 'FontSize', 16);
end

y=1;
for p=1:length(Pnp)
    for n=1:length(Pnp(p).n)
        text(21, y, num2str(Pnp(p).n(n)) );
        y=y+1;
    end
end

ylabel('Stage/Gonad length');

axis normal

end