clear all
close all

lin12_run='lin-12_all_1bin';
glp1_run='glp-1_all';

lag2_run='lag-2_all_1bin';
apx1_run='apx-1_all';

lag1_run='lag-1_all';
hlh2_run='hlh-2_all';

lin12MT_run='lin-12_MT1306';
lag2MT_run='lag-2_MT1306';

infile=sprintf('%s.mat', lin12_run);
load(infile,'Pnp');
Pnp_lin12=Pnp;

infile=sprintf('%s.mat', glp1_run);
load(infile,'Pnp');
Pnp_glp1=Pnp;

infile=sprintf('%s.mat', lag2_run);
load(infile,'Pnp');
Pnp_lag2=Pnp;

infile=sprintf('%s.mat', apx1_run);
load(infile,'Pnp');
Pnp_apx1=Pnp;

infile=sprintf('%s.mat', lag1_run);
load(infile,'Pnp');
Pnp_lag1=Pnp;

infile=sprintf('%s.mat', hlh2_run);
load(infile,'Pnp');
Pnp_hlh2=Pnp;

infile=sprintf('%s.mat', lin12MT_run);
load(infile,'Pnp');
Pnp_lin12MT=Pnp;

infile=sprintf('%s.mat', lag2MT_run);
load(infile,'Pnp');
Pnp_lag2MT=Pnp;


clear Pnp;

im1=construct2DmRNAfig(Pnp_lin12);
im2=construct2DmRNAfig(Pnp_glp1);
im3=construct2DmRNAfig(Pnp_lag2);
im4=construct2DmRNAfig(Pnp_apx1);
im5=construct2DmRNAfig(Pnp_hlh2);
im6=construct2DmRNAfig(Pnp_lag1);

im1MT=construct2DmRNAfig(Pnp_lin12MT);
im3MT=construct2DmRNAfig(Pnp_lag2MT);

%% Notches and Deltas

figure
subplot(3,2,1)
plot2DmRNAfig(Pnp_glp1,[],[],im2);

subplot(3,2,3)
plot2DmRNAfig(Pnp_lin12,im1,[],[]);

subplot(3,2,5)
plot2DmRNAfig(Pnp_lin12,im1,[],im2);

subplot(3,2,2)
plot2DmRNAfig(Pnp_apx1,[],[],im4);

subplot(3,2,4)
plot2DmRNAfig(Pnp_lag2,[],im3,[]);

subplot(3,2,6)
plot2DmRNAfig(Pnp_lag2,[],im3,im4);

%% Modulators

figure
subplot(3,2,1)
plot2DmRNAfig(Pnp_hlh2,[],im5,[]);

subplot(3,2,2)
plot2DmRNAfig(Pnp_lag1,im6,[],[]);

subplot(3,2,3)
plot2DmRNAfig(Pnp_hlh2,im6,im5,[]);

subplot(3,2,5)
plot2DmRNAfig(Pnp_hlh2,[],im5,im3);

subplot(3,2,6)
plot2DmRNAfig(Pnp_lag2,im6,[],im1);

%% MT1306

subplot(2,1,1)
plot2DmRNAfig(Pnp_lin12,im1,im3,[]);

subplot(2,1,2)
plot2DmRNAfig(Pnp_lin12MT,im1MT,im3MT,[]);
