clear all
close all

lin12_run='lin-12_all_2bins';
lin12b_run='lin-12_all';
lag2_run='lag-2_all';

%% load data

% load data for lin-12
infile=sprintf('%s.mat', lin12_run);
load(infile,'scatterMRNA', 'avgMRNA');
sm_lin12=scatterMRNA; am_lin12=avgMRNA;

% load data for lag-2
infile=sprintf('%s.mat', lag2_run);
load(infile,'scatterMRNA', 'avgMRNA');
sm_lag2=scatterMRNA; am_lag2=avgMRNA;

clear scatterMRNA avgMRNA

% load 2D data for lin-12
infile=sprintf('%s.mat', lin12_run);
load(infile,'Pnp');
Pnp_lin12=Pnp;
clear Pnp;

infile=sprintf('%s.mat', lin12b_run);
load(infile,'Pnp');
Pnp_lin12b=Pnp;
clear Pnp;

% load 2D data for lag-12
infile=sprintf('%s.mat', lag2_run);
load(infile,'Pnp');
Pnp_lag2=Pnp;
clear Pnp;

im_lin12=construct2DmRNAfig(Pnp_lin12);
im_lin12b=construct2DmRNAfig(Pnp_lin12b);
im_lag2=construct2DmRNAfig(Pnp_lag2);

%%

% plot lin-12 in all Pn.ps
n=3:8;
n_order=[5 6 7 3 4 8];

for i=1:length(n_order)
    subplot(2, 3, i);

    r=find(n==n_order(i))
    
    % plot scatter data
    plot(sm_lin12(r).L,sm_lin12(r).Nmrna, 'o', 'color', 0.7*[1 1 1]); hold on;
    % plot average data
    errorbar(am_lin12(r).L, am_lin12(r).avg, am_lin12(r).err, '-ok', 'linewidth', 1)
    
    % 
    plot([800 800], [0 200], '--k');
    plot([1100 1100], [0 200], '--k');
    
    title(sprintf('P%d.p', n_order(i)), 'FontSize', 14);
    xlabel('Gonad length');
    ylabel('# mRNA in lineage');
    hold off;
    
    ylim([0 200]);
end

%%

% plot lag-2 in P5.p-P7.p
n=3:8;
n_order=[5 6 7];

figure
for i=1:length(n_order)
    subplot(1, 3, i);

    r=find(n==n_order(i))
    
    % plot scatter data
    plot(sm_lag2(r).L,sm_lag2(r).Nmrna, 'o', 'color', 0.7*[1 1 1]); hold on;
    % plot average data
    errorbar(am_lag2(r).L, am_lag2(r).avg, am_lag2(r).err, '-ok', 'linewidth', 1)
    
    % 
    plot([800 800], [0 200], '--k');
    plot([1100 1100], [0 200], '--k');
    
    title(sprintf('P%d.p', n_order(i)), 'FontSize', 14);
    xlabel('Gonad length');
    ylabel('# mRNA in lineage');
    hold off;
    
    ylim([0 200]);
end
%%

figure;
plot2DmRNAfig(Pnp_lag2,[],im_lag2,[]);

%% 

figure;
plot2DmRNAfig(Pnp_lin12b,im_lin12b,[],[]);

%% 2D fig

figure
subplot(2,2,1)
plot2DmRNAfig(Pnp_lin12,im_lin12,[],[]);

subplot(2,2,2)
plot2DmRNAfig(Pnp_lag2,[],im_lag2,[]);

subplot(2,2,3);
plot2DmRNAfig(Pnp_lin12,im_lin12,im_lag2,[]);

% plot lag-2 and lin-12 in P6.p
subplot(2,2,4);
n=3:8; r=find(n==6);

errorbar(am_lin12(r).L, am_lin12(r).avg, am_lin12(r).err, '-or', 'linewidth', 2); hold on;
errorbar(am_lag2(r).L, am_lag2(r).avg, am_lag2(r).err, '-og', 'linewidth', 2);

plot([800 800], [0 200], '--k');
plot([1100 1100], [0 200], '--k');

title(sprintf('P%d.p', n(r)));
xlabel('Gonad length (pixels)');
ylabel('# mRNA in lineage');
hold off;

ylim([0 160]);
xlim([200 1500]);

legend('Lin-12', 'Lag-2', 'location', 'northwest');


