%%

clear all;

[file,path] = uigetfile('*.input');
run=file(1:end-6);
infile=sprintf('%s.mat', run);

%% plot scatter and average data vs gonad length

n=3:8;
r=find(n>=3 & n<=8);
f=1.1;

load(infile,'scatterMRNA', 'avgMRNA');

figure(1);

% determine max MRNA
max_MRNA=[];
for i=1:length(r)
    max_MRNA=[max_MRNA max(avgMRNA(r(i)).avg)]
end
max_MRNA=max(max_MRNA);
min_L=min(avgMRNA(1).L)-200;
max_L=max(avgMRNA(1).L)+200;

clf;
for i=1:length(r)
    subplot(2, 3, i);
    
    % plot scatter data
    plot(scatterMRNA(r(i)).L,scatterMRNA(r(i)).Nmrna, 'o', 'color', 0.7*[1 1 1]); hold on;
    % plot average data
    errorbar(avgMRNA(r(i)).L, avgMRNA(r(i)).avg, avgMRNA(r(i)).err, '-ok', 'linewidth', 1)
    
    % 
    plot([800 800], [0 f*max_MRNA], '--k');
    plot([1100 1100], [0 f*max_MRNA], '--k');
    
    title(sprintf('P%d.p', n(r(i))));
    xlabel('Gonad length');
    ylabel('# mRNA in lineage');
    hold off;
    
    if i==3
        text(max_L, 1.05*f*max_MRNA, sprintf('%s', run), 'FontSize', 14);
    end
    
    ylim([0 f*max_MRNA]);
    xlim([min_L max_L]);
end

%% make stage-ordered array graph

load(infile,'Pnp');

im=construct2DmRNAfig(Pnp);

figure(2);
clf;
plot2DmRNAfig(Pnp,im,[],[]);
text(10, -1.5, sprintf('%s', run), 'FontSize', 14);


