Nz=size(data(1).im,3);
z=round(Nz/2);
chn=1;

cont=1;

th=stretchlim(data(chn).im(:,:,z), ths(chn));
im=imadjust(data(chn).im(:,:,z), th,[]);
while cont==1
    
    % draw image of current channel
    hold off; clf;
    imshow(im, 'In', mag); hold on;
    
    % plot draw VPC ROI
    if ~isempty(ROI)
        plot(ROI(:,1), ROI(:,2), '-r');
    end
    title('Get VPC ROI');   
    
    [x,y,but]=ginput(1);

    if but==113 || but==101
        % 'q' - move up in stack with DZ=1
        % 'e' - move up in stack with DZ=5
        
        % find step size
        dz=1;
        if but==101
            dz=5
        end
        % change z coordinate
        z=z-dz;
        if z<1
            z=1;
        end
        % make new image
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        im=imadjust(data(chn).im(:,:,z), th,[]);
        
    elseif but==119 || but==114
        % 'w' - move down in stack with DZ=1
        % 'r' - move down in stack with DZ=5
        
        % find step size
        dz=1;
        if but==114
            dz=5
        end
        % change z coordinate
        z=z+dz;
        if z>Nz
            z=Nz;
        end
        % make new image
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        im=imadjust(data(chn).im(:,:,z), th,[]);
    
    elseif but==122 || but==120 || but == 99
        % 'z','x','c' - change channel to 1,2 or 3.
        
        % change channel
        if but==122
            chn=1;
        elseif but==120
            chn=2;
        elseif but==99
            chn=3;
        end
        % make new image
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        im=imadjust(data(chn).im(:,:,z), th,[]);
    elseif but==1
        % 'LMB' - add ROI point
        
        ROI(end+1,:)=[x; y];
    elseif but==3
        % 'RMB' - delete ROI point
        
        ROI(end,:)=[];
    elseif but==27
        % 'ESC' - quit
        
        close(gcf);
        cont=0;
    end

end