%%
function getThresholds (n_expt, path, channels) 

%%
% clear all
% channels={'alexa','Cy5'};
% path='E:/Jeroen/8-5-2009/lin-12_A592_lag-2_Cy5_26-40hrs_batch1';
% n_expt=9;

%% load # spot vs threshold histogram data
ana_path=[path '/analyzed/'];

infile=sprintf('filteredSpotData%04d.mat', n_expt);
load([ana_path infile], 'data_filtered', 'spotHist');

%% find thresholds

N=size(spotHist,2);
spotThreshold=zeros(1,2);

for i=1:length(channels)
    plot(1:N,spotHist(i,:));
    title(sprintf('Chn:%s expt:%d', channels{i}, n_expt));
    xlabel('Threshold');
    ylabel('# spots');
%     ylim([0 max(spotHist(i,:))/2])
    ylim([0 500])
    [x,y] = ginput(1);
    line([x x],[0 max(spotHist(i,:))]);
    spotThreshold(i)=x;
end
close (gcf);

%% save threshold data

outfile=sprintf('spotThresholds%04d.mat', n_expt);
save([ana_path outfile], 'spotThreshold');
