%%

function getMRNAperVPC (n_expt, path, channels) 

%%
% clear all
% channels={'A594','Cy5'};
% extension=['.tif'];
% path='E:/Jeroen/8-13-2009/lin-12_A594_lag-1_Cy5_26-40hr';
% 
% n_expt=30;

maxXYdist2=50^2;

%%

ana_path=[path '/analyzed/'];

outfile=sprintf('VPC_ROI%04d.mat', n_expt);
load([ana_path outfile], 'ROI');

infile=sprintf('spotCoordinates%04d.mat', n_expt);
load([ana_path infile], 'spotCoordinates');

infile=sprintf('POI%04d.mat', n_expt);
load([ana_path infile], 'POI');

%% Sort Pn.ps from anterior to posterior

% In POIs, find all VPCs (P3.p-P8.p)
PnP=[];
for i=1:length(POI)
    N=sscanf(POI(i).lbl,'%d');
    if ~isempty(N)
        if N>2 && N<9
            % store the position of the current Pn.p in the POI array
            PnP=[PnP; i];
        end
    end
end

% calculate the distance between each pair of VPCs and descendants
dist=[];
for n=1:length(PnP)
    % find the label of each Pn.p in the list
    PnP_lbl(n)=sscanf(POI( PnP(n) ).lbl,'%d');
    for m=1:length(PnP)
        % calculate the distance between the two Pn.ps
        x1=POI( PnP(n) ).pos(1:2);
        x2=POI( PnP(m) ).pos(1:2);
        dist(n,m)=sum((x1-x2).^2);
    end
end

PnP_AP_sorted=[];
PnP_lbl_AP_sorted=[];
for n=min(PnP_lbl):max(PnP_lbl)
    % find all cells with current label
    u=find(PnP_lbl==n);
    % find all cells with label posterior to that
    if n<max(PnP_lbl)
        v=find(PnP_lbl==n+1);
    else
        % for last Pn.p, actually use the anterior Pn.ps
        v=find(PnP_lbl==n-1);
    end
    
    D=[];
    for i=1:length(u)
        % for each cell in current group find closest distance to cell in
        % posterior group. The larger this distance, the more anterior the cell
        D(i)=min(sqrt(dist(u(i),v)));
    end
    if n<max(PnP_lbl)
        % sort in descending order, largest distance indicates
        % anterior-most Pn.p in this lineage
        E=sort(D,'descend');
    else
        E=sort(D,'ascend');
    end
    for i=1:length(u)
        r=find(D==E(i));
        % store position in POI array in correct A-P order
        PnP_AP_sorted(end+1)=PnP(u(r));
        % store Pn.p label in correct A-P order
        PnP_lbl_AP_sorted(end+1)=n;
    end

end

%% For each spot, find the closest Pn.p or descendant cell
for i=1:length(channels)
    x=spotCoordinates(i).data(:,1);
    y=spotCoordinates(i).data(:,2);
    
    % for all spots, calculate distance to each Pn.p cell or descendant
    dist2=zeros(length(x),length(PnP_AP_sorted));
    for j=1:length(PnP_AP_sorted)
        X=POI(PnP_AP_sorted(j)).pos(1);
        Y=POI(PnP_AP_sorted(j)).pos(2);
        dist2(:,j)=(x-X).^2+(y-Y).^2;
    end
    
    % Store label of closest Pn.p along A-P axis to each spot
    minDist2=min(dist2,[],2);
    for j=1:length(minDist2)
        % only assign label when within maxXY distance from cell
        if minDist2(j)<maxXYdist2
            r=find(dist2(j,:)==minDist2(j));
            spotLabel(i).data(j)=PnP_AP_sorted(r);
        else
            spotLabel(i).data(j)=-1;
        end            
        [sqrt([minDist2(j) maxXYdist2]) spotLabel(i).data(j)]
    end
end

%% save data into VPC structure

n=3:8;
VPC=[];
for i=1:length(n)
    % label (n in Pn.pxx)
    VPC(i).lbl=n(i);
    % number of mRNA spots for each channel in each Pn.p cell
    VPC(i).n_mRNA=zeros(length(channels),4);
    % number of cells in VPC lineage: 1, Pn.p; 2, Pn.px; 3, Pn.pxx
    VPC(i).n_cells=0;
end

for i=1:length(n)
    % find all Pn.ps and descendants in current lineage
    r=find(PnP_lbl_AP_sorted==n(i));
    % save number of cells in current lineage
    VPC(i).n_cells=length(r);
    for j=1:length(r)
        for c=1:2
            % for each cell and each channel, save number of spots found
            q=find(spotLabel(c).data==PnP_AP_sorted(r(j)));
            VPC(i).n_mRNA(c,j)=length(q);
        end
    end
end

% save VPC mRNA data

fprintf('\t#%d -- Saving VPC mRNA data\n\n', n_expt); 

outfile=sprintf('VPC_mRNA%04d.mat', n_expt);
save([ana_path outfile], 'VPC');

%% make figure

% plot spatial distribution and cell assignment for spots in both channels
c=colormap(hsv(length(PnP_AP_sorted)));

for i=1:length(channels)

    subplot(2,2,i);
    title(sprintf('Expt = %d, %s\n', n_expt, channels{i}));
    
    % plot spots
    cla;
    hold on;
    
    q=find(spotLabel(i).data==-1);
    plot(spotCoordinates(i).data(q,1),spotCoordinates(i).data(q,2), '.', 'color', 0.8*[1 1 1]);

    for j=1:length(PnP_AP_sorted)
        q=find(spotLabel(i).data==PnP_AP_sorted(j));
        plot(spotCoordinates(i).data(q,1),spotCoordinates(i).data(q,2), '.', 'color', c(j,:));
    end
    
    % plot POIs
    for j=1:length(POI)
        plot(POI(j).pos(1),POI(j).pos(2), '.k');
        text(POI(j).pos(1)+10,POI(j).pos(2)-10, POI(j).lbl, 'Color', 'k');
    end
    hold off;

    axis equal;
    
end

% plot VPC structure 

% find max mRNA number
clear q;
for i=1:length(VPC)
    q(i)=max(VPC(i).n_mRNA(:));
end

for i=1:length(VPC)
    subplot(3,6,12+i)
    MRNA=VPC(i).n_mRNA;
    if ~isempty(MRNA)
        bar(MRNA');
    end
    title(sprintf('P%d.p', VPC(i).lbl));
    ylim([0 max(q)])
    xlim([0 VPC(i).n_cells+1]);
end

ginput(1);

%% plot z coordinates

c=colormap(hsv(length(PnP_AP_sorted)));
for i=1:length(channels)

    subplot(2,1,i);
    title(sprintf('Expt = %d, %s\n', n_expt, channels{i}));
    
    % plot spots
    cla;
    hold on;
    for j=1:length(PnP_AP_sorted)
        q=find(spotLabel(i).data==PnP_AP_sorted(j));
        plot(spotCoordinates(i).data(q,1),spotCoordinates(i).data(q,3), '.', 'color', c(j,:));
    end
    
    % plot POIs
    for j=1:length(POI)
        plot(POI(j).pos(1),POI(j).pos(3), '.k');
        text(POI(j).pos(1)+10,POI(j).pos(3)-3, POI(j).lbl, 'Color', 'k');
    end
    
    hold off;
    ylim([0 25]);
    
end