Nz=size(data(1).im,3);
z=round(Nz/2);
chn=1;

cont=1;
arm=1;

th=stretchlim(data(chn).im(:,:,z), ths(chn));
im=imadjust(data(chn).im(:,:,z), th,[]);
while cont==1
    
    % draw image of current channel
    hold off; clf;
    imshow(im, 'In', mag); hold on;
    
    % draw all POI labels
    for i=1:length(POI)
        plot(POI(i).pos(1),POI(i).pos(2), '.r');
        text(POI(i).pos(1)+10,POI(i).pos(2)-10, POI(i).lbl, 'Color', 'r');
    end

    % draw gonad axis
    if ~isempty(gonadAxis.arm1)
        plot(gonadAxis.arm1(:,1), gonadAxis.arm1(:,2), '-r');
    end
    if ~isempty(gonadAxis.arm2)
        plot(gonadAxis.arm2(:,1), gonadAxis.arm2(:,2), '-b');
    end
    
    [x,y,but]=ginput(1);

    if but==113 || but==101
        % 'q' - move up in stack with DZ=1
        % 'e' - move up in stack with DZ=5
        
        % find step size
        dz=1;
        if but==101
            dz=5;
        end
        % change z coordinate
        z=z-dz;
        if z<1
            z=1;
        end
        % make new image
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        im=imadjust(data(chn).im(:,:,z), th,[]);
        
    elseif but==119 || but==114
        % 'w' - move down in stack with DZ=1
        % 'r' - move down in stack with DZ=5
        
        % find step size
        dz=1;
        if but==114
            dz=5;
        end
        % change z coordinate
        z=z+dz;
        if z>Nz
            z=Nz;
        end
        % make new image
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        im=imadjust(data(chn).im(:,:,z), th,[]);
    
    elseif but==122 || but==120 || but == 99
        % 'z','x','c' - change channel to 1,2 or 3.
        
        % change channel
        if but==122
            chn=1;
        elseif but==120
            chn=2;
        elseif but==99
            chn=3;
        end
        % make new image
        th=stretchlim(data(chn).im(:,:,z), ths(chn));
        im=imadjust(data(chn).im(:,:,z), th,[]);
    elseif but==1
        % 'LMB' - add gonadAxis point
        
        if arm==1
            gonadAxis.arm1(end+1,:)=[x; y];
        else
            gonadAxis.arm2(end+1,:)=[x; y];
        end
    elseif but==3
        % 'RMB' - delete gonadAxis point
        if arm==1
            gonadAxis.arm1(end,:)=[];
        else
            gonadAxis.arm2(end,:)=[];
        end
    elseif but==49 || but==50
        if but==49
            arm=1;
        else
            arm=2;
        end
    elseif but==27
        % 'ESC' - quit
        
        close(gcf);
        cont=0;
    end

end
