%%
function findSpots (n_expt, path, channels) 

%%
% clear all
% channels={'alexa','Cy5'};
% path='E:/Jeroen/11-10-2009/lin-12_A594_hlh-3_Cy5_N2_24_40hr/';
% 
% n_expt=4;

%% load ROI data

ana_path=[path '/analyzed/'];

outfile=sprintf('VPC_ROI%04d.mat', n_expt);
load([ana_path outfile], 'ROI');

%% make ROI and find bounds within full image

im_ROI=roipoly(1024,1024,ROI(:,1), ROI(:,2));
tmp=bwlabel(im_ROI);
rp=regionprops(tmp, 'BoundingBox');
ROI_BB=round(rp(1).BoundingBox);
im_ROI=imcrop(im_ROI, ROI_BB);

%% load filtered data

infile=sprintf('filteredSpotData%04d.mat', n_expt);
load([ana_path infile], 'data_filtered', 'spotHist');

%% load thresholds

infile=sprintf('spotThresholds%04d.mat', n_expt);
load([ana_path infile], 'spotThreshold');

%% find spots using thresholds given by user

fprintf('\t#%d -- Finding spot coordinates\n', n_expt); 

clear spotCoordinates;
for i=1:length(channels)

    fprintf('\t\t%s: ', channels{i}); 

    %% apply ROI to filtered data and normalize
    tmp=double(data_filtered(i).im);
    for j=1:size(tmp,3)
        tmp(:,:,j)=tmp(:,:,j).*im_ROI;
    end
    tmp = tmp/max(tmp(:));

    %% find spots

    % first apply user-defined threshold
    bwl = tmp>spotThreshold(i)/100;
    % select filtered image data when above threshold
    tmp=bwl.*tmp;
    % find regional maxima to separate spots that touch
    for j=1:size(tmp,3)
        % if there are non-zero pixels, find regional max
        if (~isempty( find(tmp(:,:,j)>0) ) )
            rm(:,:,j)=imregionalmax(tmp(:,:,j));
        else
            % oherwise, just leave as all zeroes
            rm(:,:,j)=tmp(:,:,j);
        end
    end
    % find regional maxima and their coordinates
    [lab,n] = bwlabeln(rm);
    rp=regionprops(lab,'Centroid');
    for j=1:length(rp)
        spotCoordinates(i).data(j,:)=rp(j).Centroid;
    end

    %% convert spot (x,y) coordinates from ROI coordinates to full image coordinates
    for j=1:2
        spotCoordinates(i).data(:,j)=spotCoordinates(i).data(:,j)+ROI_BB(j)-1;
    end

    fprintf('done \n'); 

end

%% save spot data

fprintf('\t#%d -- Saving spot coordinates\n\n', n_expt); 

outfile=sprintf('spotCoordinates%04d.mat', n_expt);
save([ana_path outfile], 'spotCoordinates');

%%


