%% 

clear all
% channels={'alexa','Cy5'};
channels={'A594','Cy5'};

% get directory containing data

path=uigetdir;

% find all stacks that have annotated worm data

ana_path=[path '/analyzed/'];
ROI_files=ls([ana_path 'VPC_ROI*.mat']);
n_expts=[];
for i=1:size(ROI_files,1)
    n_expts=[n_expts sscanf(ROI_files(i,:),'VPC_ROI%d.mat')];
end

%% log-filter mRNA imaging data and get # spot vs threshold histogram data

for i=1:length(n_expts)
    filterSpotData (n_expts(i), path, channels) 
end

%% manually get thresholds

for i=1:length(n_expts)
    getThresholds (n_expts(i), path, channels) 
end

%% find spot coordinates using manual thresholds

for i=1:length(n_expts)
    findSpots (n_expts(i), path, channels) 
end

%% for each worm, assign spots to Pn.p cell or their descendants

for i=1:length(n_expts)
    getMRNAperVPC (n_expts(i), path, channels);
end
