%%
function filterSpotData (n_expt, path, channels) 
%%

extension=['.tif'];
% 
% % channels={'alexa','Cy5'};
% channels={'A594','Cy5'};
% path='E:/Jeroen/11-10-2009/lin-12_A594_hlh-3_Cy5_N2_24_40hr';
% n_expt=12;

%% load annotation data
ana_path=[path '/analyzed/'];

outfile=sprintf('VPC_ROI%04d.mat', n_expt);
load([ana_path outfile], 'ROI');

%% make ROI and find bounds within full image

im_ROI=roipoly(1024,1024,ROI(:,1), ROI(:,2));
tmp=bwlabel(im_ROI);
rp=regionprops(tmp, 'BoundingBox');
ROI_BB=round(rp(1).BoundingBox);
im_ROI=imcrop(im_ROI, ROI_BB);

%% load stacks of all channels

for i=1:length(channels)
    infile=sprintf(['%s%03d' extension], channels{i}, n_expt);
    
    fprintf('\t#%d -- Reading imaging data: %s\n', n_expt, infile); 
    
    tmp = tiffread2c([path '/' infile]);
    for j=1:length(tmp)
        data(i).im(:,:,j) = imcrop(tmp(j).data, ROI_BB);
    end
end

clear tmp i

%% apply log filter to amplify spots

fprintf('\t#%d -- Applying log filter\n', n_expt); 

H = -fspecial('log',15,1.5);
for i=1:length(channels)
    fprintf('\t\t %s: ', channels{i}); 
    for j=1:size(data(1).im,3)
        data_filtered(i).im(:,:,j) = imfilter(data(i).im(:,:,j),H,'replicate');
        fprintf('.'); 
    end
    fprintf('\n'); 
end

%% find # mRNA vs threshold

npoints = 100;

spotHist=zeros(length(channels),npoints);

fprintf('\t#%d -- Computing thresholds (of %d)\n', n_expt, npoints);

for i=1:length(channels)

    tmp=double(data_filtered(i).im);
    for j=1:size(tmp,3)
        tmp(:,:,j)=tmp(:,:,j).*im_ROI;
    end
    tmp = tmp/max(tmp(:));

    fprintf('\t\t%s:     1', channels{i});

    for j = 1:npoints
      % Apply threshold
      bwl = tmp > j/npoints;

      % Find particles
      [lab,n] = bwlabeln(bwl);  

      % Save count into variable nout
      spotHist(i,j) = n;

      fprintf('\b\b\b%3i',j);
    end;
    fprintf('\n');

end

%% save filtered data and spot histograms

fprintf('\t#%d -- Saving data\n\n', n_expt);

outfile=sprintf('filteredSpotData%04d.mat', n_expt);
save([ana_path outfile], 'data_filtered', 'spotHist');

