function im = construct2DmRNAfig ( Pnp )

% first find out how many rows are needed
Nrows=0;
for p=1:3
    Nrows=Nrows+length(Pnp(p).n);
end

% init image
im=zeros(Nrows,4*5);

% number of pixels per cell for Pnp, Pnpx, Pnpxx
S(1).s=[4 4 4 4 4];
S(2).s=[2 2 2 2 2 2 2 2 2 2];
S(3).s=[2 2 1 1 1 1 1 1 1 1 1 1 1 1 2 2];

% construct image
n=0;
for p=1:length(Pnp)
    for i=1:length(Pnp(p).n)
        n=n+1;
        s_old=1;
        for j=1:length(Pnp(p).conf)
            s=S(p).s(j);
            if Pnp(p).n(i) ~=0
                im(n,s_old:s_old+s-1)=Pnp(p).mRNA(i,j)/Pnp(p).n(i);
            else
                im(n,s_old:s_old+s-1)=0;
            end
            [s_old s_old+s-1 s];
            s_old=s_old+s;
        end
    end
end

end