%%

clear all

[file,path] = uigetfile('*.input');
run=file(1:end-6);
infile=sprintf('%s.mat', run);

infile=sprintf('%s.input', run);
outfile=sprintf('%s.mat', run);

%% read paths and other info 

% read in the input file
input=[];
fid=fopen(infile);
tmp = textscan(fid, '%s %s %s %s %s %s %s %s');

% get name
r=strcmp(tmp{1},'name'); q=find(r==1);
input.name=tmp{2}{q};

% get root directory
r=strcmp(tmp{1},'root'); q=find(r==1);
input.root=tmp{2}{q};

fprintf('Name: %s\nRoot: %s\n', input.name, input.root);
% get all paths and channels
fprintf('Data:\n');
r=strcmp(tmp{1},'path'); q=find(r==1);
for i=1:length(q)
    input.path{i}=tmp{2}{q(i)};
    if strcmp(tmp{1}{q(i)+1}, 'channel')
        input.channel{i}=str2num( tmp{2}{q(i)+1} );
        fprintf('\tAdding channel <%d> for path <%s>\n', input.channel{i}, input.path{i});
    else
        fprintf('\tMissing channel information in <%s> for path <%s>!\n', infile, input.path{i});
        break;
    end
end

% get bins for L_gonad
r=strcmp(tmp{1},'Lbins'); q=find(r==1);
Lmin=str2num(tmp{2}{q}); 
DL=str2num(tmp{3}{q});
Lmax=str2num(tmp{4}{q});

fprintf('Bins:\n');
fprintf('\t mRNA vs L: L=%d:%d:%d\n', Lmin, DL, Lmax);

% initialize data for spatial, stage-ordered arrays
Pnp(1).conf=[4 5 6 7 8];
Pnp(1).n=[];
Pnp(1).mRNA=[];
Pnp(1).L=[];
Pnp(1).name='Pnp';

Pnp(2).conf=[4 4 5 5 6 6 7 7 8 8];
Pnp(2).n=[];
Pnp(2).mRNA=[];
Pnp(2).L=[];
Pnp(2).name='Pnpx';

Pnp(3).conf=[4 4 5 5 5 5 6 6 6 6 7 7 7 7 8 8];
Pnp(3).n=[];
Pnp(3).mRNA=[];
Pnp(3).L=[];
Pnp(3).name='Pnpxx';

% get L bins for spatial, stage-ordered array
for p=1:length(Pnp)
    r=strcmp(tmp{1},Pnp(p).name); q=find(r==1);
    fprintf('\t %s: ',Pnp(p).name);
    for i=2:size(tmp,2)
        if ~isempty(tmp{i}{q})
            Pnp(p).L(i-1)=str2num(tmp{i}{q});
            fprintf('%d ',Pnp(p).L(i-1));
        end
    end
    fprintf('\n');
end
fclose(fid);

%% for all paths load experiments to analyze

mRNA=[];
gonad=[];
file=[];
fprintf('Loading data\n');
for i=1:length(input.path)
    ana_path=[input.root '/' input.path{i} '/analyzed/'];

    % get all worms that are properly analyzed
    n_expts=[];
    VPC_mRNA_files=ls([ana_path 'VPC_mRNA*.mat']);
    for j=1:size(VPC_mRNA_files,1)
        n_expts=[n_expts sscanf(VPC_mRNA_files(j,:),'VPC_mRNA%d.mat')];
    end
    fprintf('\tReading in data for %d worms\n', length(n_expts) );
    
    for j=1:length(n_expts)
        % load mRNA data
        infile=[ana_path sprintf('VPC_mRNA%04d.mat',n_expts(j))];
        load(infile, 'VPC');
        % load gonad data
        infile=[ana_path sprintf('gonadAxis%04d.mat',n_expts(j))];
        load(infile, 'gonadAxis');

        % save data into proper structs
        if isempty(mRNA)
            for k=1:length(VPC)
                mRNA(1).data(k).lbl=VPC(k).lbl;
                mRNA(1).data(k).n_cells=VPC(k).n_cells;
                mRNA(1).data(k).n_mRNA=VPC(k).n_mRNA(input.channel{i},:);
            end
            gonad=gonadAxis;
            file(1).dir=i;
            file(1).file=j;
            file(1).filename=infile;

        else
            n=length(mRNA)+1;
            for k=1:length(VPC)
                mRNA(n).data(k).lbl=VPC(k).lbl;
                mRNA(n).data(k).n_cells=VPC(k).n_cells;
                mRNA(n).data(k).n_mRNA=VPC(k).n_mRNA(input.channel{i},:);
            end
            gonad=[gonad gonadAxis];
            file(end+1).dir=i;
            file(end).file=j;
            file(end).filename=infile;
        end
    end
end

%% for each worm calculate gonad length

fprintf('Calculating gonad lengths\n');
for i=1:length(gonad)

    x=gonad(i).arm1(:,1);
    y=gonad(i).arm1(:,2);

    dx=diff(x); dy=diff(y);
    L=sum(sqrt(dx.^2+dy.^2));

    if ~isempty(gonad(i).arm2)
        x=gonad(i).arm2(:,1);
        y=gonad(i).arm2(:,2);

        dx=diff(x); dy=diff(y);
        L=L+sum(sqrt(dx.^2+dy.^2));
    else
        L=2*L;
    end

    L_gonad(i)=L;
end

%% get scattered and average mRNA data for all VPC lineages

n=3:8;
r=find(n>=3 & n<=8);

fprintf('calculating mRNA vs gonad length data\n');

% initialize scatter data array
for i=1:length(r)
    scatterMRNA(i).lbl=n(r(i));
    scatterMRNA(i).L=[];
    scatterMRNA(i).Nmrna=[];
end

% collect scatter mRNA data
for i=1:length(mRNA)
    
    for j=1:length(r)
        Nmrna=sum(mRNA(i).data(r(j)).n_mRNA);
        scatterMRNA(j).L=[scatterMRNA(j).L L_gonad(i)];
        scatterMRNA(j).Nmrna=[scatterMRNA(j).Nmrna Nmrna];
    end
    
end

% initialize average data array
for i=1:length(r)
    avgMRNA(i).L=[];
    avgMRNA(i).avg=[];
    avgMRNA(i).err=[];
end

% calculate average mRNA binned for gonad length
L=Lmin:DL:Lmax;
for l=1:length(L)-1;
    q=find(L_gonad>=L(l) & L_gonad<L(l+1));
    Nmrna=[];
    for i=1:length(r)
        for j=1:length(q);
            Nmrna(j)=sum(mRNA(q(j)).data(r(i)).n_mRNA);
        end
        if length(Nmrna)~=0
            avgMRNA(i).L=[avgMRNA(i).L mean([L(l) L(l+1)]) ];
            avgMRNA(i).avg=[avgMRNA(i).avg mean(Nmrna)];
            avgMRNA(i).err=[avgMRNA(i).err std(Nmrna)/sqrt(length(Nmrna))];
        end
    end
end

%% make list of configurations of the P4.p-P8.p cells and corresponding gonad lengths

% n=3:8;
% r=find(n>=4 & n<=8);
% 
% confs = [1 1 1 1 1; 2 1 1 1 2; 2 2 1 2 2; 2 2 2 2 2; 2 2 4 2 2; 2 4 4 4 2];
% 
% clf; hold on;
% col='krgbmc';
% for i=1:length(col)
%     plot(0,0,col(i));
% end
% legend('1 1 1 1 1','2 1 1 1 2','2 2 1 2 2','2 2 2 2 2','2 2 4 2 2','2 4 4 4 2', 'Location', 'NorthWest');
% 
% for i=1:length(mRNA)
%     Ncells=[mRNA(i).data.n_cells];
%     sumP567p=sum(Ncells(r));
% 
%     c=0;
%     for j=1:size(confs,1)
%         if sum(Ncells(r)==0) == 0
%             if sum(Ncells(r)==confs(j,:)) == 5
%                 c=j;
%             end
%         else
%             c=-1;
%         end
%     end
% 
%     if c==0
% %         Ncells(r)
%     end
%     
%     if c>0
%         style=['o' col(c)];
%         plot(L_gonad(i), sumP567p, style);
%     elseif c==-1
%         plot(L_gonad(i), sumP567p, '*r');
%     else
%         plot(L_gonad(i), sumP567p, 'o', 'color', 0.8*[1 1 1]);
%     end
% end
% 
% plot([800 800], [0 200], '--k');
% plot([1100 1100], [0 200], '--k');
% box on;
% hold off;
% 
% ylim([4 18]);
% xlabel('Gonad length');
% ylabel('Total number of cells in P4.p-P8.p lineages');

%% collect data for spatial, stage-ordered graph

fprintf('Calculating spatial, stage-ordered average mRNA data\n');
for i=1:length(Pnp)
    Nbin_L=length(Pnp(i).L)-1;
    Pnp(i).mRNA=zeros(Nbin_L,length(Pnp(i).conf));
    Pnp(i).n=zeros(Nbin_L,1);

    % for each L bin, find corresponding worms
    for j=1:Nbin_L
        Lmin=Pnp(i).L(j);
        Lmax=Pnp(i).L(j+1);
        r=find(L_gonad>=Lmin & L_gonad<Lmax);
        % for each worm check whether cells have proper configuration
        for k=1:length(r)
            cont=1;
            lbl=[mRNA( r(k) ).data.lbl];
            for u=1:length(n)
                % find number of cells of lineage n in current configuration
                n_cells_conf=length(find(Pnp(i).conf==n(u)));
                % find number of cells of lineage n in current worm
                q=find(lbl==n(u));
                n_cells_data=mRNA( r(k) ).data(q).n_cells;
                if n_cells_conf > 0
                    if n_cells_conf ~= n_cells_data
                        % if the number of cells for this lineage do not
                        % agree, then the current worm has the wrong
                        % configuration
                        cont=0;
                    end
                end
            end

            if cont
                % if the worm has the desired VPC configuration, extract the number
                % of mRNAs

                % loop over P4.p - P8.p and descendants, get # mRNA for each of
                % the Pn.p or descendant cells
                tmp=zeros(1,length(Pnp(i).conf));
                for m=4:8
                    % find position of current Pn.p lineage in stage-ordered and data arrays
                    q_tgt=find(Pnp(i).conf==m);
                    q_src=find(n==m);
                    % find number of cells in lineage in stage-ordered and data arrays
                    nVPC=length(q_tgt);
                    nVPC_data=mRNA( r(k) ).data(q_src).n_cells;

                    % only copy data to stage-ordered array
                    tmp(q_tgt)=mRNA( r(k) ).data(q_src).n_mRNA(1:nVPC_data);

                end

                % add mRNA numbers to Pnpxx
                Pnp(i).n(j)=Pnp(i).n(j)+1;
                Pnp(i).mRNA(j,:)=Pnp(i).mRNA(j,:)+tmp;

            end
        end
    end
end

%% save data to outfile

fprintf('saving data!\n');
save(outfile, 'scatterMRNA', 'avgMRNA', 'Pnp');


