clear all
% channels={'alexa','Cy5'};
channels={'A594','Cy5'};
extension=['.tif'];
path='E:/Jeroen/8-13-2009/lin-12_A594_lag-1_Cy5_26-40hr';

n_expt=3;

%%

ana_path=[path '/analyzed/'];

outfile=sprintf('VPC_ROI%04d.mat', n_expt);
load([ana_path outfile], 'ROI');

infile=sprintf('spotCoordinates%04d.mat', n_expt);
load([ana_path infile], 'spotCoordinates');

%%

for i=1:length(channels)
    infile=sprintf(['%s%03d' extension], channels{i}, n_expt);
    
    tmp = tiffread2c([path '/' infile]);
    for j=1:length(tmp)
        data(i).im(:,:,j) = tmp(j).data;
    end
end

showStack(data(1).im,data(2).im,[], 'Points', spotCoordinates(1).data, 'ROI', ROI);

%%

% load POI

outfile=sprintf('POI%04d.mat', n_expt);
load([ana_path outfile], 'POI');

% for i=1:2
% 
%     subplot(1,2,i);
%     
%     % plot spots
%     plot(spotCoordinates(i).data(:,1),spotCoordinates(i).data(:,2), '.r');
%     hold on;
% 
%     % plot POIs
%     for j=1:length(POI)
%         plot(POI(j).pos(1),POI(j).pos(2), '.b');
%         text(POI(j).pos(1)+10,POI(j).pos(2)-10, POI(j).lbl, 'Color', 'b');
%     end
%     hold off;
% 
%     axis equal;
%     
% end

%% for every spot, find closest cell

PnP=[];
for i=1:length(POI)
    N=sscanf(POI(i).lbl,'%d');
    if ~isempty(N)
        if N>2 && N<9
            PnP=[PnP; i];
        end
    end
end

%% Sort Pn.ps from anterior to posterior

clear PnP_lbl dist PnP_AP_order

for n=1:length(PnP)
    PnP_lbl(n)=sscanf(POI( PnP(n) ).lbl,'%d');
    for m=1:length(PnP)
        lbl1=sscanf(POI( PnP(n) ).lbl,'%d');
        lbl2=sscanf(POI( PnP(m) ).lbl,'%d');
        x1=POI( PnP(n) ).pos(1:2);
        x2=POI( PnP(m) ).pos(1:2);
        dist(n,m)=sum((x1-x2).^2);
    end
end

PnP_AP_sorted=[];
PnP_lbl_AP_sorted=[];
for n=min(PnP_lbl):max(PnP_lbl)
    % find all cells with current label
    u=find(PnP_lbl==n);
    % find all cells with label posterior of that
    if n<max(PnP_lbl)
        v=find(PnP_lbl==n+1);
    else
        v=find(PnP_lbl==n-1);
    end
    
    D=[];
    for i=1:length(u)
        % for each cell in current group find closest distance to cell in
        % posterior group. The larger this distance, the more anterior the cell
        D(i)=min(sqrt(dist(u(i),v)));
    end
    if n<max(PnP_lbl)
        E=sort(D,'descend');
    else
        E=sort(D,'ascend');
    end
    for i=1:length(u)
        r=find(D==E(i));
        PnP_AP_sorted(end+1)=PnP(u(r));
        PnP_lbl_AP_sorted(end+1)=n;
    end

end

x=[];y=[];
for i=1:length(PnP_AP_sorted)
    x(end+1)=POI ( PnP_AP_sorted(i) ).pos(1);
    y(end+1)=POI ( PnP_AP_sorted(i) ).pos(2);
end

figure(2), plot(x,y,'-o');

%%
for i=1:2
    x=spotCoordinates(i).data(:,1);
    y=spotCoordinates(i).data(:,2);
    
    dist2=zeros(length(x),length(PnP_AP_sorted));
    for j=1:length(PnP_AP_sorted)
        X=POI(PnP_AP_sorted(j)).pos(1);
        Y=POI(PnP_AP_sorted(j)).pos(2);
        dist2(:,j)=(x-X).^2+(y-Y).^2;
    end
    
    minDist2=min(dist2,[],2);
    for j=1:length(minDist2)
        r=find(dist2(j,:)==minDist2(j))
        spotLabel(i).data(j)=PnP_AP_sorted(r);
    end
end

%%
c=colormap(hsv(length(PnP_AP_sorted)));
figure(1);

for i=1:2

    subplot(1,2,i);
    
    % plot spots
    cla;
    hold on;
    for j=1:length(PnP_AP_sorted)
        q=find(spotLabel(i).data==PnP_AP_sorted(j));
        plot(spotCoordinates(i).data(q,1),spotCoordinates(i).data(q,2), '.', 'color', c(j,:));
    end
    
    % plot POIs
    for j=1:length(POI)
        plot(POI(j).pos(1),POI(j).pos(2), '.b');
        text(POI(j).pos(1)+10,POI(j).pos(2)-10, POI(j).lbl, 'Color', 'b');
    end
    hold off;

    axis equal;
    
end

%% save data into VPC structure

n=3:8;
for i=1:length(n)
    VPC(i).lbl=n(i);
    VPC(i).n_mRNA=zeros(2,4);
    VPC(i).n_cells=0;
end

for i=1:length(n)
    r=find(PnP_lbl_AP_sorted==n(i));
    VPC(i).n_cells=length(r);
    for j=1:length(r)
        for c=1:2
            q=find(spotLabel(c).data==PnP_AP_sorted(r(j)));
            VPC(i).n_mRNA(c,j)=length(q);
        end
    end
end

%% plot VPC structure 

figure(2);

% find max mRNA number
for i=1:length(VPC)
    q(i)=max(VPC(i).n_mRNA(:));
end

for i=1:length(VPC)
    subplot(1,length(VPC),i)
    MRNA=VPC(i).n_mRNA(:,1:VPC(i).n_cells);
    if ~isempty(MRNA)
        bar(MRNA');
    end
    title(sprintf('P%d.p', VPC(i).lbl));
    ylim([0 max(q)])
end