%%

% This script allows one to annotate worms: 1) mark specific cells, 2) mark
% region where interesting spots are, 3) mark gonadal arms

%% initialize and get filename

clear all;
mag=75;
% channels={'dapi','alexa','Cy5'};
channels={'dapi','A594','Cy5'};
% channels={'dapi','mCherry','Cy5'};
extension=['.tif'];
% extension=['.stk'];

[filename,path]=uigetfile('dapi*', 'DialogTitle', 'E:/Jeroen/2-11-2010/apx-1_Cy5_glp-1_A594_N2_26-43hr/batch1/');
n_expt=sscanf(filename, 'dapi%d');

%% load stacks of all channels

for i=1:length(channels)
    infile=sprintf(['%s%03d' extension], channels{i}, n_expt)
    
    tmp = tiffread2c([path infile]);
    data(i).im = cat(3, tmp.data);
end

clear tmp i

%% get the POIs for this worm

% initialize POIs or load if already existing

ana_path=[path 'analyzed\'];
outfile=sprintf('POI%04d.mat', n_expt);
if isempty(ls([ana_path outfile]))
    POI=[];
else
    load([ana_path outfile], 'POI');
end

% find POIs

ths=[5e-4 1e-5 1e-5];
getPOI;

% save POI data

% check if directory exists, if not create it
ana_path=[path 'analyzed\'];
if isempty(ls(ana_path))
    mkdir(ana_path);
end

% write POI data to .MAT file in <ana_path>
save([ana_path sprintf('POI%04d.mat', n_expt)], 'POI');

%% find ROI for VPC fluorescence

% initialize VPC ROI or load if already existing

ana_path=[path 'analyzed\'];
outfile=sprintf('VPC_ROI%04d.mat', n_expt);

if isempty(ls([ana_path outfile]))
    ROI=[];
else
    load([ana_path outfile], 'ROI');
end

% find ROI for VPCs

ths=[5e-4 1e-5 1e-5];
getVPC_ROI;

% save VPC ROI data

% check if directory exists, if not create it
ana_path=[path 'analyzed\'];
if isempty(ls(ana_path))
    mkdir(ana_path);
end

% write ROI data to .MAT file in <ana_path>
save([ana_path sprintf('VPC_ROI%04d.mat', n_expt)], 'ROI');

%% find gonad axis

% initialize gonad axis or load if already existing

ana_path=[path 'analyzed\'];
outfile=sprintf('gonadAxis%04d.mat', n_expt);

if isempty(ls([ana_path outfile]))
    gonadAxis.arm1=[];
    gonadAxis.arm2=[];
else
    load([ana_path outfile], 'gonadAxis');
end

% load POI data
outfile=sprintf('POI%04d.mat', n_expt);
load([ana_path outfile], 'POI');

% find gonad axis

ths=[5e-4 1e-5 1e-5];
getGonadAxis;

% save gonad axis data

% check if directory exists, if not create it
ana_path=[path 'analyzed\'];
if isempty(ls(ana_path))
    mkdir(ana_path);
end

% write gonad axis data to .MAT file in <ana_path>
save([ana_path sprintf('gonadAxis%04d.mat', n_expt)], 'gonadAxis');

