/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.TreeHashGenerator;
import com.amazonaws.services.glacier.model.DescribeVaultOutput;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.transfer.ArchiveTransferManager;
import com.amazonaws.services.glacier.transfer.UploadResult;
import com.brianmcmichael.SimpleGlacierUploader.AmazonDownloadRequest;
import com.brianmcmichael.SimpleGlacierUploader.ContextMenuMouseListener;
import com.brianmcmichael.SimpleGlacierUploader.DeleteArchiveFrame;
import com.brianmcmichael.SimpleGlacierUploader.Endpoints;
import com.brianmcmichael.SimpleGlacierUploader.FileDrop;
import com.brianmcmichael.SimpleGlacierUploader.InventoryRequest;
import com.brianmcmichael.SimpleGlacierUploader.JHyperlinkLabel;
import com.brianmcmichael.SimpleGlacierUploader.UploadWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

public class SimpleGlacierUploader
extends Frame
implements ActionListener {
    Properties applicationProps = new Properties();
    private static final long quotaUMSLBiologyvault = 110000000000000L;
    private static final long quotaUMSLChemistryvault = 100000000000000L;
    private static final long quotaUMSLPhysicsvault = 40000000000000L;
    private static final long quotaUMSLPsychologyvault = 800000000000L;
    private static final long quotaUMSLDefaultvault = 10000000L;
    private static final long serialVersionUID = 11041980L;
    private static final String versionNumber = "0.74.6";
    private static final String logFileNamelog = "Glacier.log";
    private static final String logFileNametxt = "Glacier.txt";
    private static final String logFileNamecsv = "Glacier.csv";
    private static final String logFileNameerr = "GlacierErrors.txt";
    private static final String fileProperties = "SAGU.properties";
    private static final String regionOne = "US East (Northern Virginia)";
    private static final String regionTwo = "US West (Oregon)";
    private static final String regionThree = "US West (Northern California)";
    private static final String regionFour = "EU (Ireland)";
    private static final String regionFive = "Asia Pacific (Tokyo)";
    public static final String curDir = System.getProperty("user.dir");
    private static final String NO_DIRECTORIES_ERROR = "Directories, folders, and packages are not supported. \nPlease compress this into a single archive (such as a .zip) and try uploading again.";
    private static final String LOG_CREATION_ERROR = "There was an error creating the log.";
    private static final String LOG_WRITE_ERROR = "There was an error writing to the log.";
    public static final String DOWNLOAD_STRING = "Download Archive";
    public static final String INVENTORY_REQUEST_STRING = "Request Inventory";
    public static final String COPYRIGHT_STRING = "Simple Amazon Glacier Uploader\nVersion 0.74.6\n \ufffd2012-2013 Brian McMichael";
    public static final String UPDATE_STRING = "Check for Update";
    public static final String UPDATE_SITE_STRING = "http://simpleglacieruploader.brianmcmichael.com/";
    public static final String ABOUT_WINDOW_STRING = "Simple Amazon Glacier Uploader\nVersion 0.74.6\n \ufffd2012-2013 Brian McMichael\n\nReport errors or direct correspondence to: brian@brianmcmichael.com\n\nSimple Amazon Glacier Uploader is free software. \nYour feedback is appreciated.\nThis program is not any way affiliated with Amazon Web Services or Amazon.com.";
    public static final String URL_STRING = "http://simpleglacieruploader.brianmcmichael.com/";
    public static final String AWS_SITE_STRING = "Get AWS Credentials";
    public static final String ACCESS_LABEL = "Access Key: ";
    public static final int SOCKET_TIMEOUT = 1000000;
    public static final int MAX_RETRIES = 6;
    Color wc = Color.WHITE;
    Color rc = Color.RED;
    Color bc = Color.BLACK;
    int width = 200;
    int height = 170;
    int fileInt = 0;
    long max_file_size = 0x100000000L;
    static JFrame frmMain;
    static Container pane;
    static JButton btnDo;
    static JProgressBar barDo;
    DataOutputStream output;
    AmazonGlacierClient client;
    ContextMenuMouseListener rmb = new ContextMenuMouseListener();
    File[] multiFiles;
    Font f3 = new Font("Helvetica", 1, 20);
    Font f4 = new Font("Helvetica", 0, 11);
    Dimension buttonDimension = new Dimension(180, 27);
    URL xIconUrl = this.getClass().getResource("/smallx.png");
    ImageIcon xIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.xIconUrl));
    URL downIconUrl = this.getClass().getResource("/arrowDown.png");
    ImageIcon downIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.downIconUrl));
    URL exitIconUrl = this.getClass().getResource("/powerButton.png");
    ImageIcon exitIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.exitIconUrl));
    URL logIconUrl = this.getClass().getResource("/logKey.png");
    ImageIcon logIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.logIconUrl));
    URL toolsIconUrl = this.getClass().getResource("/tools.png");
    ImageIcon toolsIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.toolsIconUrl));
    URL saveIconUrl = this.getClass().getResource("/floppy.png");
    ImageIcon saveIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.saveIconUrl));
    URL logViewIconUrl = this.getClass().getResource("/logView.png");
    ImageIcon logViewIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.logViewIconUrl));
    URL updateIconUrl = this.getClass().getResource("/paper.png");
    ImageIcon updateIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.updateIconUrl));
    URL userUrl = this.getClass().getResource("/littleguy.png");
    ImageIcon userIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.userUrl));
    URL logoUrl = this.getClass().getResource("/umsl.png");
    JLabel logoLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.logoUrl)));
    File uploadFile = null;
    JPanel mainPanel = new JPanel();
    JPanel o1 = new JPanel();
    JPanel p1 = new JPanel();
    JPanel p2 = new JPanel();
    JPanel p3 = new JPanel();
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenuItem saveFileMnu = new JMenuItem("Export Log", this.saveIcon);
    JMenuItem exitApplicationMnu = new JMenuItem("Exit", this.exitIcon);
    JMenu retrieveMenu = new JMenu("Retrieve");
    JMenuItem getAWSCredentialsLinkMnu = new JMenuItem("Get AWS Credentials", this.userIcon);
    JMenuItem downloadFileMnu = new JMenuItem("Download Archive", this.downIcon);
    JMenu viewMenu = new JMenu("View");
    JMenuItem viewLog = new JMenuItem("View Log", this.logViewIcon);
    JCheckBoxMenuItem logCheckMenuItem = new JCheckBoxMenuItem("Logging On/Off", this.logIcon);
    JRadioButtonMenuItem logLogRadio = new JRadioButtonMenuItem(".log");
    JRadioButtonMenuItem logTxtRadio = new JRadioButtonMenuItem(".txt");
    JRadioButtonMenuItem logCsvRadio = new JRadioButtonMenuItem(".csv");
    ButtonGroup logFileGroup = new ButtonGroup();
    JMenu deleteMenu = new JMenu("Delete");
    JMenuItem deleteArchiveMnu = new JMenuItem("Delete Archive", this.xIcon);
    JPanel titlePanel = new JPanel();
    JLabel titleLabel = new JLabel("UMSL Glacier Uploader");
    JPanel credentialsPanel = new JPanel(new GridLayout(4, 1, 10, 10));
    JHyperlinkLabel accessLabel = new JHyperlinkLabel("Access Key: ");
    JTextField accessField = new JTextField(21);
    JLabel secretLabel = new JLabel("Secret Key: ");
    JPasswordField secretField = new JPasswordField(41);
    JPanel locationPanel = new JPanel();
    JLabel locationName = new JLabel("Upload Location: ");
    JComboBox locationChoice = new JComboBox();
    JButton loginButton = new JButton("Load Vaults");
    JPanel vaultPanel = new JPanel();
    JHyperlinkLabel vaultSelectLabel = new JHyperlinkLabel("Select Existing:");
    JComboBox vaultSelector = new JComboBox();
    JHyperlinkLabel vaultName = new JHyperlinkLabel("Vault Name: ");
    JTextField vaultField = new JTextField(15);
    JPanel logoPanel = new JPanel();
    JPanel logPanel = new JPanel();
    JButton logButton = new JButton("View Log");
    JButton downloadRequestButton = new JButton("Download Archive");
    JButton inventoryRequestButton = new JButton("Request Inventory");
    JPanel selectionsPanel = new JPanel();
    JButton selectFileButton = new JButton("Select File");
    JButton clearButton = new JButton("Clear");
    JPanel fileDropPanel = new JPanel();
    JTextArea ddText = new JTextArea();
    JScrollPane ddScroll = new JScrollPane(this.ddText);
    FileDrop fileDropHere = new FileDrop(this.ddText, new FileDrop.Listener(){
        File thisFile = null;

        @Override
        public void filesDropped(File[] files) {
            SimpleGlacierUploader.this.ddText.setEditable(false);
            File[] goodFiles = new File[files.length];
            boolean j = false;
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    try {
                        SimpleGlacierUploader.this.ddText.append("Unable to upload: " + files[i].getCanonicalPath() + "\n");
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(null, SimpleGlacierUploader.NO_DIRECTORIES_ERROR, "Error", 0);
                    files[i] = null;
                    continue;
                }
                try {
                    SimpleGlacierUploader.this.ddText.append(files[i].getCanonicalPath() + "\n");
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            files = SimpleGlacierUploader.this.removeNullFile(files);
            SimpleGlacierUploader.this.multiFiles = SimpleGlacierUploader.this.multiFiles != null ? SimpleGlacierUploader.this.concatFileArray(SimpleGlacierUploader.this.multiFiles, files) : files;
            if (SimpleGlacierUploader.this.multiFiles.length == 0) {
                SimpleGlacierUploader.this.uploadButton.setText("Select File(s)");
            } else if (SimpleGlacierUploader.this.multiFiles.length == 1) {
                SimpleGlacierUploader.this.uploadButton.setText("Upload File");
            } else if (SimpleGlacierUploader.this.multiFiles.length > 1) {
                SimpleGlacierUploader.this.uploadButton.setText("Upload Files");
            }
        }
    });
    JButton uploadButton = new JButton("Upload");
    JPanel copyrightPanel = new JPanel();
    JLabel copyrightLabel = new JLabel("Simple Amazon Glacier Uploader\nVersion 0.74.6\n \ufffd2012-2013 Brian McMichael");
    JHyperlinkLabel updateLink = new JHyperlinkLabel("\tCheck for Update");
    JFileChooser fc = new JFileChooser();

    public SimpleGlacierUploader() {
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new BorderLayout());
        this.o1.setLayout(new GridLayout(1, 3, 10, 10));
        this.p1.setLayout(new GridLayout(3, 1, 3, 3));
        this.p2.setLayout(new BorderLayout());
        this.p3.setLayout(new BorderLayout());
        this.titlePanel.setBackground(this.wc);
        this.titlePanel.add(this.titleLabel);
        this.titleLabel.setFont(this.f3);
        this.credentialsPanel.setBackground(this.wc);
        this.credentialsPanel.setBorder(BorderFactory.createTitledBorder("AWS Credentials"));
        this.credentialsPanel.add(this.accessLabel);
        this.credentialsPanel.add(this.accessField);
        this.accessField.addMouseListener(this.rmb);
        this.accessField.setPreferredSize(this.buttonDimension);
        this.credentialsPanel.add(this.secretLabel);
        this.credentialsPanel.add(this.secretField);
        this.secretField.addMouseListener(this.rmb);
        this.secretField.setPreferredSize(this.buttonDimension);
        this.locationPanel.setBackground(this.wc);
        this.locationPanel.setBorder(BorderFactory.createTitledBorder("Server Location"));
        this.locationPanel.add(this.locationChoice);
        this.locationChoice.setPreferredSize(this.buttonDimension);
        this.locationChoice.setBackground(this.wc);
        this.locationChoice.addItem(regionOne);
        this.locationChoice.addActionListener(this);
        this.locationPanel.add(this.loginButton);
        this.loginButton.addActionListener(this);
        this.loginButton.setBackground(this.wc);
        this.loginButton.setPreferredSize(this.buttonDimension);
        this.vaultPanel.setBackground(this.wc);
        this.vaultPanel.setBorder(BorderFactory.createTitledBorder("Vault Selection"));
        this.vaultPanel.add(this.vaultSelector);
        this.vaultSelector.setBackground(this.wc);
        this.vaultSelector.addActionListener(this);
        this.vaultSelector.setPreferredSize(this.buttonDimension);
        this.vaultPanel.add(this.vaultField);
        this.vaultField.addActionListener(this);
        this.vaultField.setPreferredSize(this.buttonDimension);
        this.logoPanel.setBackground(this.wc);
        this.logoPanel.add(this.logoLabel);
        this.logPanel.setBackground(this.wc);
        this.logPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        this.logPanel.add(this.logButton);
        this.logButton.setBackground(this.wc);
        this.logButton.addActionListener(this);
        this.logButton.setPreferredSize(this.buttonDimension);
        this.logPanel.add(this.downloadRequestButton);
        this.downloadRequestButton.setBackground(this.wc);
        this.downloadRequestButton.addActionListener(this);
        this.downloadRequestButton.setPreferredSize(this.buttonDimension);
        this.logPanel.add(this.inventoryRequestButton);
        this.inventoryRequestButton.setBackground(this.wc);
        this.inventoryRequestButton.addActionListener(this);
        this.inventoryRequestButton.setPreferredSize(this.buttonDimension);
        this.selectionsPanel.setBackground(this.wc);
        this.selectionsPanel.add(this.selectFileButton);
        this.selectFileButton.setBackground(this.wc);
        this.selectFileButton.addActionListener(this);
        this.selectFileButton.setPreferredSize(new Dimension(110, 27));
        this.selectionsPanel.add(this.clearButton);
        this.clearButton.setBackground(this.wc);
        this.clearButton.addActionListener(this);
        this.clearButton.setPreferredSize(new Dimension(70, 27));
        this.fileDropPanel.setBackground(this.wc);
        this.fileDropPanel.setLayout(new BorderLayout());
        this.fileDropPanel.setBorder(BorderFactory.createTitledBorder("Drag and Drop Files"));
        this.fileDropPanel.add((Component)this.ddScroll, "Center");
        this.ddText.setEditable(false);
        this.ddScroll.setSize(180, 300);
        this.p1.setBackground(this.wc);
        this.p1.add(this.credentialsPanel);
        this.p1.add(this.locationPanel);
        this.p1.add(this.vaultPanel);
        this.p2.setBackground(this.wc);
        this.p2.add((Component)this.logoPanel, "North");
        this.p2.add((Component)this.logPanel, "Center");
        this.p3.setBackground(this.wc);
        this.p3.add((Component)this.selectionsPanel, "North");
        this.p3.add((Component)this.fileDropPanel, "Center");
        this.p3.add((Component)this.uploadButton, "South");
        this.uploadButton.setBackground(this.wc);
        this.uploadButton.addActionListener(this);
        this.p3.setBorder(BorderFactory.createTitledBorder("Uploads"));
        this.o1.setBackground(this.wc);
        this.o1.add(this.p1);
        this.o1.add(this.p2);
        this.o1.add(this.p3);
        this.mainPanel.add((Component)this.o1, "Center");
        this.mainPanel.setBackground(this.wc);
        this.mainPanel.add((Component)this.menuBar, "North");
        this.mainPanel.add((Component)this.copyrightPanel, "South");
        this.menuBar.setBackground(this.wc);
        this.menuBar.add(this.fileMenu);
        this.fileMenu.setBackground(this.wc);
        this.fileMenu.add(this.saveFileMnu);
        this.saveFileMnu.setBackground(this.wc);
        this.saveFileMnu.addActionListener(this);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitApplicationMnu);
        this.exitApplicationMnu.setBackground(this.wc);
        this.exitApplicationMnu.addActionListener(this);
        this.menuBar.add(this.retrieveMenu);
        this.retrieveMenu.setBackground(this.wc);
        this.retrieveMenu.add(this.getAWSCredentialsLinkMnu);
        this.getAWSCredentialsLinkMnu.setBackground(this.wc);
        this.getAWSCredentialsLinkMnu.addActionListener(this);
        this.retrieveMenu.add(this.downloadFileMnu);
        this.downloadFileMnu.setBackground(this.wc);
        this.downloadFileMnu.addActionListener(this);
        this.menuBar.add(this.viewMenu);
        this.viewMenu.setBackground(this.wc);
        this.viewMenu.add(this.viewLog);
        this.viewLog.setBackground(this.wc);
        this.viewLog.addActionListener(this);
        this.viewMenu.add(this.logCheckMenuItem);
        this.logCheckMenuItem.setBackground(this.wc);
        this.logCheckMenuItem.setSelected(true);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.logLogRadio);
        this.logLogRadio.setBackground(this.wc);
        this.logLogRadio.setSelected(true);
        this.logFileGroup.add(this.logLogRadio);
        this.viewMenu.add(this.logTxtRadio);
        this.logFileGroup.add(this.logTxtRadio);
        this.logTxtRadio.setBackground(this.wc);
        this.viewMenu.add(this.logCsvRadio);
        this.logCsvRadio.setBackground(this.wc);
        this.logFileGroup.add(this.logCsvRadio);
        this.menuBar.add(this.deleteMenu);
        this.deleteMenu.add(this.deleteArchiveMnu);
        this.deleteArchiveMnu.setBackground(this.wc);
        this.deleteArchiveMnu.addActionListener(this);
        this.add((Component)this.mainPanel, "Center");
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        try {
            FileInputStream in = new FileInputStream(SimpleGlacierUploader.getFilePropertiesPath());
            this.applicationProps.load(in);
            this.accessField.setText(this.applicationProps.getProperty("accessKey"));
            this.secretField.setText(this.applicationProps.getProperty("secretKey"));
            this.vaultField.setText(this.applicationProps.getProperty("vaultKey"));
            this.locationChoice.setSelectedIndex(Integer.parseInt(this.applicationProps.getProperty("locationSet")));
            if (this.applicationProps.getProperty("logType") == null) {
                this.setLogFileType(0);
            } else {
                this.setLogFileType(Integer.parseInt(this.applicationProps.getProperty("logType")));
            }
            in.close();
        }
        catch (FileNotFoundException e1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pack();
        if (this.width < this.getWidth()) {
            this.width = this.getWidth();
        }
        if (this.height < this.getHeight()) {
            this.height = this.getHeight();
        }
        this.centerOnScreen(this.width, this.height);
    }

    public void setLogFileType(int intype) {
        if (intype == 0) {
            this.logLogRadio.setSelected(true);
        } else if (intype == 1) {
            this.logTxtRadio.setSelected(true);
        } else if (intype == 0) {
            this.logCsvRadio.setSelected(true);
        } else {
            this.logLogRadio.setSelected(true);
        }
    }

    public int getLogFileType() {
        if (this.logLogRadio.isSelected()) {
            return 0;
        }
        if (this.logTxtRadio.isSelected()) {
            return 1;
        }
        if (this.logCsvRadio.isSelected()) {
            return 2;
        }
        return 0;
    }

    public static String getLogFilename(int filename) {
        if (filename == 0) {
            return logFileNamelog;
        }
        if (filename == 1) {
            return logFileNametxt;
        }
        if (filename == 2) {
            return logFileNamecsv;
        }
        return logFileNamelog;
    }

    public static File getLogFilenamePath(int filepath) {
        if (filepath == 0) {
            File logFile = new File(curDir + System.getProperty("file.separator") + logFileNamelog);
            return logFile;
        }
        if (filepath == 1) {
            File logFile = new File(curDir + System.getProperty("file.separator") + logFileNametxt);
            return logFile;
        }
        if (filepath == 2) {
            File logFile = new File(curDir + System.getProperty("file.separator") + logFileNamecsv);
            return logFile;
        }
        if (filepath == 3) {
            File logFile = new File(curDir + System.getProperty("file.separator") + logFileNameerr);
            return logFile;
        }
        File logFile = new File(curDir + System.getProperty("file.separator") + logFileNamelog);
        return logFile;
    }

    public static String getFileProperties() {
        return fileProperties;
    }

    public static File getFilePropertiesPath() {
        File propsFile = new File(curDir + System.getProperty("file.separator") + fileProperties);
        return propsFile;
    }

    private void SaveCurrentProperties(String accessString, String secretString, String vaultString, int selectedIndex) {
        try {
            FileOutputStream out = new FileOutputStream(SimpleGlacierUploader.getFilePropertiesPath());
            this.applicationProps.setProperty("accessKey", accessString);
            this.applicationProps.setProperty("secretKey", secretString);
            this.applicationProps.setProperty("vaultKey", vaultString);
            this.applicationProps.setProperty("locationSet", Integer.toString(selectedIndex));
            this.applicationProps.setProperty("logType", SimpleGlacierUploader.convertSimple(this.getLogFileType()));
            this.applicationProps.store(out, "Properties");
            out.close();
        }
        catch (FileNotFoundException e1) {
        }
        catch (IOException e1) {
            // empty catch block
        }
    }

    public static String convertSimple(int i) {
        return "" + i;
    }

    public boolean checkAWSFields() {
        boolean passBool = false;
        if (this.accessField.getText().trim().equals("") || this.secretField.getText().trim().equals("")) {
            if (this.accessField.getText().trim().equals("")) {
                this.accessField.setFocusable(true);
                this.accessField.requestFocus();
            } else if (this.secretField.getText().trim().equals("")) {
                this.secretField.setFocusable(true);
                this.secretField.requestFocus();
            }
            JOptionPane.showMessageDialog(null, "You must enter your AWS credentials.", "Error", 0);
            passBool = false;
        } else if (this.accessField.getText().trim().length() != 20 || this.secretField.getText().trim().length() != 40) {
            if (this.accessField.getText().trim().length() != 20) {
                this.accessField.setFocusable(true);
                this.accessField.requestFocus();
                JOptionPane.showMessageDialog(null, "Your AWS Access Key does not appear to be valid.", "Error", 0);
                passBool = false;
            } else if (this.secretField.getText().trim().length() != 40) {
                this.secretField.setFocusable(true);
                this.secretField.requestFocus();
                JOptionPane.showMessageDialog(null, "Your AWS Secret Key does not appear to be valid.", "Error", 0);
                passBool = false;
            }
        } else {
            passBool = true;
        }
        return passBool;
    }

    public boolean checkAllFields() {
        boolean passBool = false;
        if (this.accessField.getText().trim().equals("") || this.vaultField.getText().trim().equals("") || this.secretField.getText().trim().equals("")) {
            if (this.accessField.getText().trim().equals("")) {
                this.accessField.setFocusable(true);
                this.accessField.requestFocus();
            } else if (this.secretField.getText().trim().equals("")) {
                this.secretField.setFocusable(true);
                this.secretField.requestFocus();
            } else if (this.vaultField.getText().trim().equals("")) {
                this.vaultField.setFocusable(true);
                this.vaultField.requestFocus();
            }
            JOptionPane.showMessageDialog(null, "You must complete all fields.", "Error", 0);
            passBool = false;
        } else if (this.accessField.getText().trim().length() != 20 || this.secretField.getText().trim().length() != 40) {
            if (this.accessField.getText().trim().length() != 20) {
                this.accessField.setFocusable(true);
                this.accessField.requestFocus();
                JOptionPane.showMessageDialog(null, "Your AWS Access Key does not appear to be valid.", "Error", 0);
                passBool = false;
            } else if (this.secretField.getText().trim().length() != 40) {
                this.secretField.setFocusable(true);
                this.secretField.requestFocus();
                JOptionPane.showMessageDialog(null, "Your AWS Secret Key does not appear to be valid.", "Error", 0);
                passBool = false;
            }
        } else {
            passBool = true;
        }
        return passBool;
    }

    public boolean checkForFile() {
        boolean passBool;
        if (this.multiFiles == null) {
            JOptionPane.showMessageDialog(null, "Please select a file.", "Error", 0);
            passBool = false;
        } else {
            passBool = true;
        }
        return passBool;
    }

    public String getVaultField() {
        return this.vaultField.getText().trim();
    }

    public String getAccessField() {
        return this.accessField.getText().trim();
    }

    public String getSecretField() {
        return this.secretField.getText().trim();
    }

    public long getQuota() {
        if (this.getVaultField().equals("UMSLBiologyvault")) {
            return 110000000000000L;
        }
        if (this.getVaultField().equals("UMSLChemistryvault")) {
            return 100000000000000L;
        }
        if (this.getVaultField().equals("UMSLPhysicsvault")) {
            return 40000000000000L;
        }
        if (this.getVaultField().equals("UMSLPsychologyvault")) {
            return 800000000000L;
        }
        return 10000000L;
    }

    public int getServerRegion() {
        return this.locationChoice.getSelectedIndex();
    }

    public void clearFile() {
        this.uploadFile = null;
        this.uploadButton.setText("Upload File(s)");
        this.ddText.setText("");
    }

    public void repopulateVaults(String accessString, String secretString, int regionInt) {
        int newLoc = this.locationChoice.getSelectedIndex();
        if (!this.accessField.getText().trim().equals("") && !this.secretField.getText().trim().equals("")) {
            AmazonGlacierClient newVaultCheckClient = new AmazonGlacierClient();
            newVaultCheckClient = this.makeClient(accessString, secretString, newLoc);
            String marker = null;
            this.vaultSelector.removeAllItems();
            this.vaultSelector.addItem("Select:");
            do {
                ListVaultsRequest lv = new ListVaultsRequest().withMarker(marker).withLimit("1000");
                ListVaultsResult lvr = newVaultCheckClient.listVaults(lv);
                ArrayList<DescribeVaultOutput> vList = new ArrayList<DescribeVaultOutput>(lvr.getVaultList());
                marker = lvr.getMarker();
                for (DescribeVaultOutput vault : vList) {
                    this.vaultSelector.addItem(vault.getVaultName());
                }
            } while (marker != null);
        }
    }

    public void centerOnScreen(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        int left = x < 0 ? 0 : x;
        int top = y < 0 ? 0 : y;
        this.setBounds(left, top, width, height);
    }

    void centerFrame(JFrame f) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        int fw = (int)(screen.getWidth() / 4.0);
        int fh = (int)(screen.getWidth() / 4.0);
        f.setSize(fw, fh);
        int lx = (int)(screen.getWidth() * 3.0 / 8.0);
        int ly = (int)(screen.getHeight() * 3.0 / 8.0);
        f.setLocation(lx, ly);
    }

    void centerDefineFrame(JFrame f, int width, int height) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        f.setSize(width, height);
        int lx = (int)(screen.getWidth() * 3.0 / 8.0);
        int ly = (int)(screen.getHeight() * 3.0 / 8.0);
        f.setLocation(lx, ly);
    }

    public static String getRegion(int reg) {
        String regString;
        switch (reg) {
            case 0: {
                regString = regionOne;
                break;
            }
            case 1: {
                regString = regionTwo;
                break;
            }
            case 2: {
                regString = regionThree;
                break;
            }
            case 3: {
                regString = regionFour;
                break;
            }
            case 4: {
                regString = regionFive;
                break;
            }
            default: {
                regString = regionOne;
            }
        }
        return regString;
    }

    public File[] removeNullFile(File[] a) {
        ArrayList<File> removed = new ArrayList<File>();
        for (File fle : a) {
            if (fle == null) continue;
            removed.add(fle);
        }
        return removed.toArray(new File[0]);
    }

    public File[] concatFileArray(File[] A, File[] B) {
        File[] C = new File[A.length + B.length];
        System.arraycopy(A, 0, C, 0, A.length);
        System.arraycopy(B, 0, C, A.length, B.length);
        return C;
    }

    public AmazonGlacierClient makeClient(String accessorString, String secretiveString, int region) {
        BasicAWSCredentials credentials = new BasicAWSCredentials(accessorString, secretiveString);
        this.client = new AmazonGlacierClient(credentials);
        Endpoints ep = new Endpoints(region);
        this.client.setEndpoint(ep.Endpoint());
        return this.client;
    }

    public static String regexClean(String statement) {
        String stmt = statement;
        String regex = "[^a-zA-Z0-9_\\-\\.]";
        String out = stmt.replaceAll(regex, "");
        return out;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String accessString = this.getAccessField();
        String secretString = this.getSecretField();
        String vaultString = this.getVaultField();
        int regionInt = this.getServerRegion();
        if (e.getSource() == this.vaultSelector && this.vaultSelector.getSelectedItem() != null) {
            if (this.vaultSelector.getSelectedIndex() == 0) {
                this.vaultField.setText("");
            } else {
                this.vaultField.setText(this.vaultSelector.getSelectedItem().toString());
            }
        }
        if (e.getSource() == this.loginButton) {
            this.repopulateVaults(accessString, secretString, regionInt);
        }
        if (e.getSource() == this.exitApplicationMnu) {
            System.exit(0);
        }
        if (e.getSource() == this.saveFileMnu) {
            FileDialog fd = new FileDialog(new Frame(), "Save...", 1);
            fd.setFile(logFileNametxt);
            fd.setDirectory(curDir);
            fd.setLocation(50, 50);
            fd.setVisible(true);
            String filePath = "" + fd.getDirectory() + System.getProperty("file.separator") + fd.getFile();
            File outFile = new File(filePath);
            if (!(outFile.equals("") || outFile.equals("null") || outFile == null)) {
                try {
                    FileReader fr = new FileReader(SimpleGlacierUploader.getLogFilenamePath(0));
                    BufferedReader br = new BufferedReader(fr);
                    FileWriter saveFile = new FileWriter(outFile.toString());
                    int count = 0;
                    boolean moreLines = true;
                    String ln1 = "";
                    String ln2 = "";
                    String ln3 = "";
                    while (moreLines) {
                        ln1 = br.readLine();
                        ln2 = br.readLine();
                        ln3 = br.readLine();
                        if (ln1 == null) {
                            ln1 = "";
                        }
                        if (ln2 == null) {
                            ln2 = "";
                        }
                        if (ln3 == null) {
                            ln3 = "";
                        }
                        saveFile.write(ln1);
                        saveFile.write("\r\n");
                        saveFile.write(ln2);
                        saveFile.write("\r\n");
                        saveFile.write(ln3);
                        saveFile.write("\r\n");
                        ++count;
                        if (!ln3.equals("")) continue;
                        moreLines = false;
                        br.close();
                        saveFile.close();
                        JOptionPane.showMessageDialog(null, "Successfully exported " + count + " archive records to " + outFile.toString(), "Export", 1);
                    }
                }
                catch (FileNotFoundException e1) {
                    JOptionPane.showMessageDialog(null, "Unable to locate Glacier.log", "Error", 0);
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (e.getSource() == this.viewLog || e.getSource() == this.logButton) {
            JHyperlinkLabel.OpenURI("" + SimpleGlacierUploader.getLogFilenamePath(this.getLogFileType()).toURI());
        }
        if (e.getSource() == this.deleteArchiveMnu && this.checkAllFields()) {
            AmazonGlacierClient newDeleteClient = new AmazonGlacierClient();
            newDeleteClient = this.makeClient(accessString, secretString, regionInt);
            DeleteArchiveFrame daf = new DeleteArchiveFrame(newDeleteClient, vaultString, regionInt);
            daf.setVisible(true);
        }
        if (e.getSource() == this.inventoryRequestButton && this.checkAllFields()) {
            AmazonGlacierClient newInventoryClient = new AmazonGlacierClient();
            newInventoryClient = this.makeClient(accessString, secretString, regionInt);
            InventoryRequest ir = new InventoryRequest(newInventoryClient, vaultString, regionInt);
            ir.setVisible(true);
        }
        if ((e.getSource() == this.downloadRequestButton || e.getSource() == this.downloadFileMnu) && this.checkAllFields()) {
            AmazonGlacierClient newDownloadClient = new AmazonGlacierClient();
            newDownloadClient = this.makeClient(accessString, secretString, regionInt);
            BasicAWSCredentials credentials = new BasicAWSCredentials(accessString, secretString);
            AmazonDownloadRequest adr = new AmazonDownloadRequest(newDownloadClient, vaultString, regionInt, credentials);
            adr.setVisible(true);
        }
        if (e.getSource() == this.clearButton) {
            this.ddText.setText("");
            this.uploadButton.setText("Select Files");
            this.multiFiles = null;
        }
        if (e.getSource() == this.locationChoice) {
            this.repopulateVaults(accessString, secretString, regionInt);
        }
        if (e.getSource() == this.selectFileButton && (returnVal = this.fc.showOpenDialog(this)) == 0) {
            if (this.fc.getSelectedFile().isFile()) {
                File[] thisFile = new File[]{this.fc.getSelectedFile()};
                try {
                    this.ddText.append(thisFile[0].getCanonicalPath() + "\n");
                }
                catch (IOException f) {
                    // empty catch block
                }
                this.multiFiles = this.multiFiles != null ? this.concatFileArray(this.multiFiles, thisFile) : thisFile;
            } else {
                JOptionPane.showMessageDialog(null, NO_DIRECTORIES_ERROR, "Error", 0);
            }
        }
        if (e.getSource() == this.uploadButton && this.checkAllFields() && this.checkForFile()) {
            this.SaveCurrentProperties(accessString, secretString, vaultString, this.locationChoice.getSelectedIndex());
            SwingWorker uploadWorker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    String accessString = SimpleGlacierUploader.this.getAccessField();
                    String secretString = SimpleGlacierUploader.this.getSecretField();
                    Long quota = SimpleGlacierUploader.this.getQuota();
                    String vaultName = SimpleGlacierUploader.this.getVaultField();
                    File[] uploadFileBatch = SimpleGlacierUploader.this.multiFiles;
                    long totalSize = 0L;
                    long uploadedSize = 0L;
                    for (File f : uploadFileBatch) {
                        totalSize += f.length();
                    }
                    int locInt = SimpleGlacierUploader.this.locationChoice.getSelectedIndex();
                    SimpleGlacierUploader.this.multiFiles = null;
                    SimpleGlacierUploader.this.clearFile();
                    UploadWindow uw = new UploadWindow();
                    ClientConfiguration config = new ClientConfiguration();
                    config.setSocketTimeout(1000000);
                    config.setMaxErrorRetry(6);
                    System.out.println("before client credentials");
                    BasicAWSCredentials credentials = new BasicAWSCredentials(accessString, secretString);
                    SimpleGlacierUploader.this.client = new AmazonGlacierClient(credentials, config);
                    try {
                        DescribeVaultRequest describeVaultRequest = new DescribeVaultRequest().withVaultName(vaultName);
                        DescribeVaultResult describeVaultResult = SimpleGlacierUploader.this.client.describeVault(describeVaultRequest);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "You do not have access to this vault!", "Error!", 0);
                        uw.dispose();
                    }
                    DescribeVaultRequest request = new DescribeVaultRequest().withVaultName(vaultName);
                    DescribeVaultResult vaultMeta = SimpleGlacierUploader.this.client.describeVault(request);
                    if (vaultMeta.getSizeInBytes() + totalSize < quota) {
                        if (uploadFileBatch.length > 0) {
                            ArrayList<String> uploadList = new ArrayList<String>();
                            for (int i = 0; i < uploadFileBatch.length; ++i) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                                Endpoints ep = new Endpoints(locInt);
                                SimpleGlacierUploader.this.client.setEndpoint(ep.Endpoint());
                                String locationUpped = ep.Location();
                                String thisFile = uploadFileBatch[i].getCanonicalPath();
                                String cleanFile = SimpleGlacierUploader.regexClean(thisFile);
                                System.out.println("before try/catch");
                                try {
                                    System.out.println("before atm");
                                    ArchiveTransferManager atm = new ArchiveTransferManager(SimpleGlacierUploader.this.client, credentials);
                                    String fileLength = Long.toString(uploadFileBatch[i].length());
                                    uw.setTitle("(" + (i + 1) + "/" + uploadFileBatch.length + ")" + " Uploading: " + thisFile);
                                    System.out.println("before upload");
                                    UploadResult result = atm.upload(vaultName, cleanFile, uploadFileBatch[i]);
                                    System.out.println("before add to log");
                                    uw.addToLog("Done: " + thisFile + "\n");
                                    int percentage = (int)((double)(uploadedSize += uploadFileBatch[i].length()) / (double)totalSize * 100.0);
                                    uw.updateProgress(percentage);
                                    BufferedWriter plainOutputLog = null;
                                    BufferedWriter plainOutputTxt = null;
                                    BufferedWriter plainOutputCsv = null;
                                    if (SimpleGlacierUploader.this.logCheckMenuItem.isSelected()) {
                                        String treeHash = TreeHashGenerator.calculateTreeHash(uploadFileBatch[i]);
                                        try {
                                            plainOutputLog = new BufferedWriter(new FileWriter(SimpleGlacierUploader.getLogFilenamePath(0), true));
                                            plainOutputTxt = new BufferedWriter(new FileWriter(SimpleGlacierUploader.getLogFilenamePath(1), true));
                                            plainOutputCsv = new BufferedWriter(new FileWriter(SimpleGlacierUploader.getLogFilenamePath(2), true));
                                        }
                                        catch (IOException ex) {
                                            JOptionPane.showMessageDialog(null, SimpleGlacierUploader.LOG_CREATION_ERROR, "IO Error", 0);
                                            uw.dispose();
                                            System.exit(1);
                                        }
                                        try {
                                            Date d = new Date();
                                            String thisResult = result.getArchiveId();
                                            plainOutputLog.write(System.getProperty("line.separator"));
                                            plainOutputLog.write(" | ArchiveID: " + thisResult + " ");
                                            plainOutputLog.write(System.getProperty("line.separator"));
                                            plainOutputLog.write(" | File: " + thisFile + " ");
                                            plainOutputLog.write(" | Bytes: " + fileLength + " ");
                                            plainOutputLog.write(" | Vault: " + vaultName + " ");
                                            plainOutputLog.write(" | Location: " + locationUpped + " ");
                                            plainOutputLog.write(" | Date: " + d.toString() + " ");
                                            plainOutputLog.write(" | Quota: " + quota + " ");
                                            plainOutputLog.write(" | Currently Used: " + vaultMeta.getSizeInBytes() + " ");
                                            plainOutputLog.write(" | Hash: " + treeHash + " ");
                                            plainOutputLog.write(System.getProperty("line.separator"));
                                            ((Writer)plainOutputLog).close();
                                            plainOutputTxt.write(System.getProperty("line.separator"));
                                            plainOutputTxt.write(" | ArchiveID: " + thisResult + " ");
                                            plainOutputTxt.write(System.getProperty("line.separator"));
                                            plainOutputTxt.write(" | File: " + thisFile + " ");
                                            plainOutputTxt.write(" | Bytes: " + fileLength + " ");
                                            plainOutputTxt.write(" | Vault: " + vaultName + " ");
                                            plainOutputTxt.write(" | Location: " + locationUpped + " ");
                                            plainOutputTxt.write(" | Date: " + d.toString() + " ");
                                            plainOutputTxt.write(" | Quota: " + quota + " ");
                                            plainOutputTxt.write(" | Currently Used: " + vaultMeta.getSizeInBytes() + " ");
                                            plainOutputTxt.write(" | Hash: " + treeHash + " ");
                                            plainOutputTxt.write(System.getProperty("line.separator"));
                                            ((Writer)plainOutputTxt).close();
                                            plainOutputCsv.write("" + thisResult + ",");
                                            plainOutputCsv.write("" + thisFile + ",");
                                            plainOutputCsv.write("" + fileLength + ",");
                                            plainOutputCsv.write("" + vaultName + ",");
                                            plainOutputCsv.write("" + quota + ",");
                                            plainOutputCsv.write("" + vaultMeta.getSizeInBytes() + ",");
                                            plainOutputCsv.write("" + locationUpped + ",");
                                            plainOutputCsv.write("" + d.toString() + ",");
                                            plainOutputCsv.write("" + treeHash + ",");
                                            plainOutputCsv.write(System.getProperty("line.separator"));
                                            ((Writer)plainOutputCsv).close();
                                            uploadList.add("Successfully uploaded " + thisFile + " to vault " + vaultName + " at " + locationUpped + ". Bytes: " + fileLength + ". ArchiveID Logged.\n");
                                        }
                                        catch (IOException c) {
                                            JOptionPane.showMessageDialog(null, SimpleGlacierUploader.LOG_WRITE_ERROR, "IO Error", 0);
                                            uw.dispose();
                                            System.exit(1);
                                        }
                                    } else {
                                        JOptionPane.showMessageDialog(null, "Upload Complete!\nArchive ID: " + result.getArchiveId() + "\nIt may take some time for Amazon to update the inventory.", "Uploaded", 1);
                                        SimpleGlacierUploader.this.multiFiles = null;
                                        uw.dispose();
                                    }
                                    SimpleGlacierUploader.this.clearFile();
                                    continue;
                                }
                                catch (Exception h) {
                                    if (SimpleGlacierUploader.this.logCheckMenuItem.isSelected()) {
                                        this.writeToErrorLog(h, thisFile);
                                    }
                                    JOptionPane.showMessageDialog(null, "" + h, "Error", 0);
                                    uw.dispose();
                                }
                            }
                            StringBuilder sb = new StringBuilder();
                            for (int j = 0; j < uploadFileBatch.length; ++j) {
                                sb.append((String)uploadList.get(j));
                            }
                            uw.dispose();
                            JOptionPane.showMessageDialog(null, "Upload Complete! \n" + sb, "Uploaded", 1);
                            SimpleGlacierUploader.this.multiFiles = null;
                            SimpleGlacierUploader.this.clearFile();
                        } else {
                            JOptionPane.showMessageDialog(null, "This wasn't supposed to happen.", "Bug!", 0);
                            uw.dispose();
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "This upload will exceed your quota.\nThis upload size: " + totalSize + " bytes\nYour current vault usage: " + vaultMeta.getSizeInBytes() + " bytes\nYour quota size " + quota + " bytes", "Error!", 0);
                        uw.dispose();
                    }
                    return null;
                }

                private void writeToErrorLog(Exception h, String thisFile) {
                    String thisError = h.toString();
                    BufferedWriter errorOutputLog = null;
                    try {
                        errorOutputLog = new BufferedWriter(new FileWriter(SimpleGlacierUploader.getLogFilenamePath(3), true));
                    }
                    catch (Exception badLogCreate) {
                        JOptionPane.showMessageDialog(null, SimpleGlacierUploader.LOG_CREATION_ERROR, "IO Error", 0);
                        System.exit(1);
                    }
                    try {
                        Date d = new Date();
                        errorOutputLog.write(System.getProperty("line.separator"));
                        errorOutputLog.write("" + d.toString() + ": \"" + thisFile + "\" *ERROR* " + thisError);
                        errorOutputLog.write(System.getProperty("line.separator"));
                    }
                    catch (Exception badLogWrite) {
                        JOptionPane.showMessageDialog(null, SimpleGlacierUploader.LOG_WRITE_ERROR, "IO Error", 0);
                        System.exit(1);
                    }
                }
            };
            uploadWorker.execute();
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleGlacierUploader g = new SimpleGlacierUploader();
        g.setBounds(300, 300, 650, 475);
        g.setTitle("UMSL Glacier Uploader ");
        g.setVisible(true);
    }

    public class UseFileDialog {
        public String loadFile(Frame f, String title, String defDir, String fileType) {
            FileDialog fd = new FileDialog(f, title, 0);
            fd.setFile(fileType);
            fd.setDirectory(defDir);
            fd.setLocation(50, 50);
            fd.setVisible(true);
            return fd.getFile();
        }

        public String saveFile(Frame f, String title, String defDir, String fileType) {
            FileDialog fd = new FileDialog(f, title, 1);
            fd.setFile(fileType);
            fd.setDirectory(defDir);
            fd.setLocation(50, 50);
            fd.setVisible(true);
            return fd.getFile();
        }
    }
}

