/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.JLabel;

public class JHyperlinkLabel
extends JLabel {
    private Color underlineColor = null;

    public JHyperlinkLabel(String label) {
        super(label);
        this.setForeground(Color.BLUE.darker());
        this.setCursor(new Cursor(12));
        this.addMouseListener(new HyperlinkLabelMouseAdapter());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.underlineColor == null ? this.getForeground() : this.underlineColor);
        Insets insets = this.getInsets();
        int left = insets.left;
        if (this.getIcon() != null) {
            left += this.getIcon().getIconWidth() + this.getIconTextGap();
        }
        g.drawLine(left, this.getHeight() - 1 - insets.bottom, (int)this.getPreferredSize().getWidth() - insets.right, this.getHeight() - 1 - insets.bottom);
    }

    public static void OpenURI(String url) {
        Desktop desktop;
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported (fatal)");
            System.exit(1);
        }
        if (url.length() == 0) {
            System.out.println("Usage: OpenURI [URI [URI ... ]]");
            System.exit(0);
        }
        if (!(desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop doesn't support the browse action (fatal)");
            System.exit(1);
        }
        try {
            URI uri = new URI(url);
            desktop.browse(uri);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public void setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
    }

    public class HyperlinkLabelMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (JHyperlinkLabel.this.getText().equals("Access Key: ")) {
                JHyperlinkLabel.OpenURI("https://portal.aws.amazon.com/gp/aws/securityCredentials");
            } else if (JHyperlinkLabel.this.getText().equals("Vault Name: ")) {
                JHyperlinkLabel.OpenURI("https://console.aws.amazon.com/glacier/home");
            } else if (!JHyperlinkLabel.this.getText().equals(" View Log") && JHyperlinkLabel.this.getText().equals("Check for Update")) {
                JHyperlinkLabel.OpenURI("http://simpleglacieruploader.brianmcmichael.com/");
            }
        }
    }
}

