/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.JobParameters;
import com.brianmcmichael.SimpleGlacierUploader.SimpleGlacierUploader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class InventoryRequest
extends JFrame
implements ActionListener,
WindowListener {
    AmazonGlacierClient irClient;
    String irVault;
    int irRegion;
    private static final long serialVersionUID = 1L;
    public static final String DOWNLOAD_NOTICE = "<html><body><br>Your data is stored on Glacier Servers by ArchiveID.<br>This function requests a list of Glacier ArchiveID's within a particular vault.<br><br>>> Verify that the server and vault on the previous page match the vault<br> you are attmpting to obtain the inventory from.<br>>> Once you click the 'retrieve' button it will take approximately 4 hours <br>for Amazon to process your request.<br>>> Once your files have been prepared your download will begin automatically.<br>>> You will be notified when your inventory had been retrieved successfully.<br><br> WARNING: <br>Closing the program during a retrieval request will cancel your download.</body><html>";
    public static final String curDir = System.getProperty("user.dir");
    String dlCode;
    JButton jbtInventoryRequest;
    JButton jbtBack;
    JFileChooser fc = new JFileChooser();
    long WAIT_TIME = 600000L;
    int width = 200;
    int height = 170;
    Color wc = Color.WHITE;

    public InventoryRequest(AmazonGlacierClient thisClient, String thisVault, int thisRegion) {
        super("Request Inventory");
        this.irClient = thisClient;
        this.irVault = thisVault;
        this.irRegion = thisRegion;
        JLabel label1 = new JLabel("Request Archive Inventory from " + this.irVault + " in server region " + SimpleGlacierUploader.getRegion(this.irRegion) + ":");
        JLabel label2 = new JLabel(DOWNLOAD_NOTICE);
        this.jbtInventoryRequest = new JButton("Request Inventory");
        this.jbtBack = new JButton("Back");
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(label1);
        p1.setBackground(this.wc);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)label2, "Center");
        label2.setHorizontalAlignment(0);
        p2.setBackground(this.wc);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout());
        p3.add(this.jbtInventoryRequest);
        this.jbtInventoryRequest.addActionListener(this);
        this.jbtInventoryRequest.setBackground(this.wc);
        p3.add(this.jbtBack);
        this.jbtBack.addActionListener(this);
        this.jbtBack.setBackground(this.wc);
        p3.setBackground(this.wc);
        JPanel p4 = new JPanel();
        p4.setLayout(new BorderLayout());
        p4.add((Component)p1, "North");
        p4.add((Component)p2, "Center");
        p4.add((Component)p3, "South");
        this.setContentPane(p4);
        this.addWindowListener(this);
        this.pack();
        if (this.width < this.getWidth()) {
            this.width = this.getWidth();
        }
        if (this.height < this.getHeight()) {
            this.height = this.getHeight();
        }
        this.centerOnScreen(this.width, this.height);
    }

    public void centerOnScreen(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        int left = x < 0 ? 0 : x;
        int top = y < 0 ? 0 : y;
        this.setBounds(left, top, width, height);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbtInventoryRequest) {
            SwingWorker inventoryWorker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    Date d = new Date();
                    JFrame inventoryFrame = new JFrame("Waiting for inventory");
                    inventoryFrame.setDefaultCloseOperation(2);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    cal.add(12, 250);
                    String doneString = cal.getTime().toString();
                    JLabel doneTimeLabel = new JLabel("<html><body>Inventory of vault " + InventoryRequest.this.irVault + " requested.<br>Estimated completion by " + doneString + "</html></body>");
                    JProgressBar dumJProgressBar = new JProgressBar(0);
                    dumJProgressBar.setIndeterminate(true);
                    inventoryFrame.add((Component)dumJProgressBar, "North");
                    inventoryFrame.add((Component)doneTimeLabel, "Center");
                    inventoryFrame.setBackground(InventoryRequest.this.wc);
                    inventoryFrame.setSize(300, 60);
                    InventoryRequest.this.centerDefineFrame(inventoryFrame, 500, 100);
                    inventoryFrame.setVisible(true);
                    try {
                        String inputLine;
                        JobParameters jParameters = new JobParameters().withType("inventory-retrieval");
                        InitiateJobRequest initJobRequest = new InitiateJobRequest().withVaultName(InventoryRequest.this.irVault).withJobParameters(jParameters);
                        InitiateJobResult initJobResult = InventoryRequest.this.irClient.initiateJob(initJobRequest);
                        String thisJobId = initJobResult.getJobId();
                        Thread.sleep(12600000L);
                        Boolean success = InventoryRequest.this.waitForJob(InventoryRequest.this.irClient, InventoryRequest.this.irVault, thisJobId);
                        while (!success.booleanValue()) {
                            Thread.sleep(InventoryRequest.this.WAIT_TIME);
                            success = InventoryRequest.this.waitForJob(InventoryRequest.this.irClient, InventoryRequest.this.irVault, thisJobId);
                        }
                        GetJobOutputRequest gjoRequest = new GetJobOutputRequest().withVaultName(InventoryRequest.this.irVault).withJobId(thisJobId);
                        GetJobOutputResult gjoResult = InventoryRequest.this.irClient.getJobOutput(gjoRequest);
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMMdd_HHmmss");
                        String fileDate = formatter.format((Object)d);
                        String fileName = InventoryRequest.this.irVault + fileDate + ".txt";
                        String filePath = "" + curDir + System.getProperty("file.separator") + fileName;
                        FileWriter fileStream = new FileWriter(filePath);
                        BufferedWriter out = new BufferedWriter(fileStream);
                        BufferedReader in = new BufferedReader(new InputStreamReader(gjoResult.getBody()));
                        while ((inputLine = in.readLine()) != null) {
                            out.write(inputLine);
                        }
                        out.close();
                        inventoryFrame.setVisible(false);
                        JOptionPane.showMessageDialog(null, "Successfully exported " + InventoryRequest.this.irVault + " inventory to " + filePath.toString(), "Saved", 1);
                        return null;
                    }
                    catch (AmazonServiceException k) {
                        JOptionPane.showMessageDialog(null, "The server returned an error. Files will not be inventoried for 24 hours after upload. Also check that correct location of vault has been set on the previous page.", "Error", 0);
                        System.out.println("" + k);
                        inventoryFrame.setVisible(false);
                    }
                    catch (AmazonClientException i) {
                        JOptionPane.showMessageDialog(null, "Client Error. Check that all fields are correct. Inventory not requested.", "Error", 0);
                        inventoryFrame.setVisible(false);
                    }
                    catch (Exception j) {
                        JOptionPane.showMessageDialog(null, "Inventory not found. Unspecified Error.", "Error", 0);
                        inventoryFrame.setVisible(false);
                    }
                    return null;
                }
            };
            inventoryWorker.execute();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.jbtBack) {
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Please choose a valid action.");
        }
    }

    private boolean waitForJob(AmazonGlacierClient client, String vaultName, String jobId) {
        boolean inventoryReady = false;
        try {
            DescribeJobRequest djRequest = new DescribeJobRequest(vaultName, jobId);
            DescribeJobResult djResult = client.describeJob(djRequest);
            inventoryReady = djResult.getCompleted();
        }
        catch (Exception e) {
            // empty catch block
        }
        return inventoryReady;
    }

    void centerDefineFrame(JFrame f, int width, int height) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        f.setSize(width, height);
        int lx = (int)(screen.getWidth() * 3.0 / 8.0);
        int ly = (int)(screen.getHeight() * 3.0 / 8.0);
        f.setLocation(lx, ly);
    }
}

