/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.brianmcmichael.SimpleGlacierUploader.ContextMenuMouseListener;
import com.brianmcmichael.SimpleGlacierUploader.SimpleGlacierUploader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DeleteArchiveFrame
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    String deleteCode;
    JTextField jtfDeleteField;
    JButton jbtDelete;
    JButton jbtBack;
    AmazonGlacierClient deleteClient;
    int locationChoice;
    String deleteVault;
    ContextMenuMouseListener rmb = new ContextMenuMouseListener();

    public DeleteArchiveFrame(AmazonGlacierClient client, String vaultName, int region) {
        super("Delete Archive");
        int width = 200;
        int height = 170;
        int thisRegion = region;
        Color wc = Color.WHITE;
        this.deleteClient = client;
        this.deleteVault = vaultName;
        JLabel label1 = new JLabel("ArchiveID to Delete from " + SimpleGlacierUploader.getRegion(thisRegion) + ":");
        this.jtfDeleteField = new JTextField(100);
        this.jbtDelete = new JButton("Delete");
        this.jbtBack = new JButton("Back");
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(label1);
        p1.setBackground(wc);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.jtfDeleteField);
        this.jtfDeleteField.addMouseListener(this.rmb);
        this.jtfDeleteField.setFocusable(true);
        p2.setBackground(wc);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout());
        p3.add(this.jbtDelete);
        this.jbtDelete.addActionListener(this);
        this.jbtDelete.setBackground(wc);
        p3.add(this.jbtBack);
        this.jbtBack.addActionListener(this);
        this.jbtBack.setBackground(wc);
        p3.setBackground(wc);
        JPanel p4 = new JPanel();
        p4.setLayout(new BorderLayout());
        p4.setBackground(wc);
        p4.add((Component)p1, "North");
        p4.add((Component)p2, "Center");
        p4.add((Component)p3, "South");
        this.setContentPane(p4);
        this.pack();
        if (width < this.getWidth()) {
            width = this.getWidth();
        }
        if (height < this.getHeight()) {
            height = this.getHeight();
        }
        this.centerOnScreen(width, height);
        this.jtfDeleteField.setText("");
        this.jtfDeleteField.requestFocus();
    }

    public void centerOnScreen(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        int left = x < 0 ? 0 : x;
        int top = y < 0 ? 0 : y;
        this.setBounds(left, top, width, height);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
        this.jtfDeleteField.setText("");
        this.jtfDeleteField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbtDelete) {
            if (this.jtfDeleteField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, "Enter the Archive ID of the file to be deleted.", "Error", 0);
            } else {
                try {
                    String archiveId = this.jtfDeleteField.getText().trim();
                    String sendThis = archiveId.replaceAll("[^\\p{Print}]", "");
                    String vaultName = this.deleteVault;
                    this.deleteClient.deleteArchive(new DeleteArchiveRequest().withVaultName(vaultName).withArchiveId(sendThis));
                    JOptionPane.showMessageDialog(null, "Deleted archive successfully.", "Success", 1);
                }
                catch (AmazonServiceException k) {
                    JOptionPane.showMessageDialog(null, "The server returned an error. Wait 24 hours after submitting an archive to attempt a delete. Also check that correct location of archive has been set on the previous page.", "Error", 0);
                    System.out.println("" + k);
                }
                catch (AmazonClientException i) {
                    JOptionPane.showMessageDialog(null, "Client Error. Check that all fields are correct. Archive not deleted.", "Error", 0);
                }
                catch (Exception j) {
                    JOptionPane.showMessageDialog(null, "Archive not deleted. Unspecified Error.", "Error", 0);
                }
                this.jtfDeleteField.setText("");
                this.jtfDeleteField.requestFocus();
            }
        } else if (e.getSource() == this.jbtBack) {
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Please choose a valid action.");
        }
    }
}

