/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class ContextMenuMouseListener
extends MouseAdapter {
    private JPopupMenu popup = new JPopupMenu();
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action undoAction = new AbstractAction("Undo"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ContextMenuMouseListener.this.textComponent.setText("");
            ContextMenuMouseListener.this.textComponent.replaceSelection(ContextMenuMouseListener.this.savedString);
            ContextMenuMouseListener.this.lastActionSelected = Actions.UNDO;
        }
    };
    private Action selectAllAction;
    private JTextComponent textComponent;
    private String savedString = "";
    private Actions lastActionSelected;
    private static final long serialVersionUID = 1L;

    public ContextMenuMouseListener() {
        this.popup.add(this.undoAction);
        this.popup.addSeparator();
        this.cutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this.lastActionSelected = Actions.CUT;
                ContextMenuMouseListener.this.savedString = ContextMenuMouseListener.this.textComponent.getText();
                ContextMenuMouseListener.this.textComponent.cut();
            }
        };
        this.popup.add(this.cutAction);
        this.copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this.lastActionSelected = Actions.COPY;
                ContextMenuMouseListener.this.textComponent.copy();
            }
        };
        this.popup.add(this.copyAction);
        this.pasteAction = new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this.lastActionSelected = Actions.PASTE;
                ContextMenuMouseListener.this.savedString = ContextMenuMouseListener.this.textComponent.getText();
                ContextMenuMouseListener.this.textComponent.paste();
            }
        };
        this.popup.add(this.pasteAction);
        this.popup.addSeparator();
        this.selectAllAction = new AbstractAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ContextMenuMouseListener.this.lastActionSelected = Actions.SELECT_ALL;
                ContextMenuMouseListener.this.textComponent.selectAll();
            }
        };
        this.popup.add(this.selectAllAction);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getModifiers() == 4) {
            if (!(e.getSource() instanceof JTextComponent)) {
                return;
            }
            this.textComponent = (JTextComponent)e.getSource();
            this.textComponent.requestFocus();
            boolean enabled = this.textComponent.isEnabled();
            boolean editable = this.textComponent.isEditable();
            boolean nonempty = this.textComponent.getText() != null && !this.textComponent.getText().equals("");
            boolean marked = this.textComponent.getSelectedText() != null;
            boolean pasteAvailable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).isDataFlavorSupported(DataFlavor.stringFlavor);
            this.undoAction.setEnabled(enabled && editable && (this.lastActionSelected == Actions.CUT || this.lastActionSelected == Actions.PASTE));
            this.cutAction.setEnabled(enabled && editable && marked);
            this.copyAction.setEnabled(enabled && marked);
            this.pasteAction.setEnabled(enabled && editable && pasteAvailable);
            this.selectAllAction.setEnabled(enabled && nonempty);
            int nx = e.getX();
            if (nx > 500) {
                nx -= this.popup.getSize().width;
            }
            this.popup.show(e.getComponent(), nx, e.getY() - this.popup.getSize().height);
        }
    }

    private static enum Actions {
        UNDO,
        CUT,
        COPY,
        PASTE,
        SELECT_ALL;

    }
}

