/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.transfer.ArchiveTransferManager;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.brianmcmichael.SimpleGlacierUploader.ContextMenuMouseListener;
import com.brianmcmichael.SimpleGlacierUploader.Endpoints;
import com.brianmcmichael.SimpleGlacierUploader.SimpleGlacierUploader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;

class AmazonDownloadRequest
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    public static final String DOWNLOAD_NOTICE = "<html><body><br>Amazon stores your data as a stream of data by archive ID.<br>This information can be found in your log file.<br><br>>> Ensure that Amazon SQS and SNS messaging services are enabled in your AWS console.<br><br>>> Verify that the server and vault on the previous page match the archive<br> you are attmpting to retrieve and enter the archive ID.<br>>> You will then be prompted to select the file name and the location where <br>you would like to save the data.<br>>> Once you click the 'retrieve' button it will take approximately 4 hours <br>for Amazon to process your request.<br>>> Once your files have been prepared your download will begin automatically.<br>>> You will be notified when your download has completed successfully.<br><br> WARNING: <br>Closing the program during a retrieval request will cancel your download.</body><html>";
    String dlCode;
    JTextField jtfDownloadField;
    JButton jbtDownload;
    JButton jbtBack;
    AmazonGlacierClient dlClient;
    BasicAWSCredentials dlCredentials;
    int locationChoice;
    String dlVault;
    JFileChooser fc = new JFileChooser();
    ContextMenuMouseListener rmb = new ContextMenuMouseListener();
    String archiveId;

    public AmazonDownloadRequest(AmazonGlacierClient client, String vaultName, int region, BasicAWSCredentials credentials) {
        super("Request Download");
        int width = 200;
        int height = 170;
        int thisRegion = region;
        Color wc = Color.WHITE;
        this.dlClient = client;
        this.dlVault = vaultName;
        this.locationChoice = region;
        this.dlCredentials = credentials;
        JLabel label1 = new JLabel("ArchiveID to Download from " + this.dlVault + " in server region " + SimpleGlacierUploader.getRegion(thisRegion) + ":");
        this.jtfDownloadField = new JTextField(100);
        JLabel label2 = new JLabel(DOWNLOAD_NOTICE);
        this.jbtDownload = new JButton("Request Download");
        this.jbtBack = new JButton("Back");
        this.fc.setFileSelectionMode(0);
        this.fc.setDialogTitle("Save File As");
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(label1);
        p1.setBackground(wc);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)this.jtfDownloadField, "North");
        this.jtfDownloadField.addMouseListener(this.rmb);
        this.jtfDownloadField.setFocusable(true);
        p2.add((Component)label2, "Center");
        label2.setHorizontalAlignment(0);
        p2.setBackground(wc);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout());
        p3.add(this.jbtDownload);
        this.jbtDownload.addActionListener(this);
        this.jbtDownload.setBackground(wc);
        p3.add(this.jbtBack);
        this.jbtBack.addActionListener(this);
        this.jbtBack.setBackground(wc);
        p3.setBackground(wc);
        JPanel p4 = new JPanel();
        p4.setBackground(wc);
        p4.setLayout(new BorderLayout());
        p4.add((Component)p1, "North");
        p4.add((Component)p2, "Center");
        p4.add((Component)p3, "South");
        this.setContentPane(p4);
        this.addWindowListener(this);
        this.pack();
        if (width < this.getWidth()) {
            width = this.getWidth();
        }
        if (height < this.getHeight()) {
            height = this.getHeight();
        }
        this.centerOnScreen(width, height);
        this.jtfDownloadField.setText("");
        this.jtfDownloadField.requestFocus();
    }

    public void centerOnScreen(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        int left = x < 0 ? 0 : x;
        int top = y < 0 ? 0 : y;
        this.setBounds(left, top, width, height);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
        this.jtfDownloadField.setText("");
        this.jtfDownloadField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbtDownload) {
            this.archiveId = this.jtfDownloadField.getText().trim();
            if (this.archiveId.equals("")) {
                JOptionPane.showMessageDialog(null, "Enter the Archive ID of the file to be requested.", "Error", 0);
            } else {
                SwingWorker downloadWorker = new SwingWorker(){
                    private String archiveId;
                    {
                        this.archiveId = AmazonDownloadRequest.this.jtfDownloadField.getText().trim();
                    }

                    protected Object doInBackground() throws Exception {
                        JFrame downloadFrame = new JFrame("Downloading");
                        downloadFrame.setDefaultCloseOperation(2);
                        JProgressBar dumJProgressBar = new JProgressBar(0);
                        dumJProgressBar.setIndeterminate(true);
                        downloadFrame.add((Component)dumJProgressBar, "North");
                        downloadFrame.setSize(300, 60);
                        AmazonDownloadRequest.this.centerDefineFrame(downloadFrame, 300, 50);
                        String archiveId = AmazonDownloadRequest.this.jtfDownloadField.getText().trim();
                        try {
                            String vaultName = AmazonDownloadRequest.this.dlVault;
                            FileDialog fd = new FileDialog(new Frame(), "Save Archive As...", 1);
                            fd.setFile("Save Archive As...");
                            fd.setDirectory(System.getProperty("user.dir"));
                            fd.setLocation(50, 50);
                            fd.setVisible(true);
                            String filePath = "" + fd.getDirectory() + System.getProperty("file.separator") + fd.getFile();
                            File outFile = new File(filePath);
                            if (outFile != null) {
                                downloadFrame.setTitle("Downloading " + outFile.toString());
                                downloadFrame.setVisible(true);
                                Endpoints notificationEP = new Endpoints(AmazonDownloadRequest.this.locationChoice);
                                AmazonSQSClient dlSQS = new AmazonSQSClient(AmazonDownloadRequest.this.dlCredentials);
                                AmazonSNSClient dlSNS = new AmazonSNSClient(AmazonDownloadRequest.this.dlCredentials);
                                dlSQS.setEndpoint(notificationEP.sqsEndpoint());
                                dlSNS.setEndpoint(notificationEP.snsEndpoint());
                                ArchiveTransferManager atm = new ArchiveTransferManager(AmazonDownloadRequest.this.dlClient, dlSQS, dlSNS);
                                atm.download("-", vaultName, archiveId, outFile);
                                JOptionPane.showMessageDialog(null, "Sucessfully downloaded " + outFile.toString(), "Success", 1);
                                downloadFrame.setVisible(false);
                            }
                        }
                        catch (AmazonServiceException k) {
                            JOptionPane.showMessageDialog(null, "The server returned an error. Wait 24 hours after submitting an archive to attempt a download. Also check that correct location of archive has been set on the previous page.", "Error", 0);
                            System.out.println("" + k);
                            downloadFrame.setVisible(false);
                        }
                        catch (AmazonClientException i) {
                            JOptionPane.showMessageDialog(null, "Client Error. Check that all fields are correct. Archive not downloaded.", "Error", 0);
                            downloadFrame.setVisible(false);
                        }
                        catch (Exception j) {
                            JOptionPane.showMessageDialog(null, "Archive not found. Unspecified Error.", "Error", 0);
                            downloadFrame.setVisible(false);
                        }
                        return null;
                    }
                };
                downloadWorker.execute();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getSource() == this.jbtBack) {
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Please choose a valid action.");
        }
    }

    void centerDefineFrame(JFrame f, int width, int height) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screen = tk.getScreenSize();
        f.setSize(width, height);
        int lx = (int)(screen.getWidth() * 3.0 / 8.0);
        int ly = (int)(screen.getHeight() * 3.0 / 8.0);
        f.setLocation(lx, ly);
    }
}

