/*
 * Decompiled with CFR 0.152.
 */
package com.brianmcmichael.SimpleGlacierUploader;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.brianmcmichael.SimpleGlacierUploader.ContextMenuMouseListener;
import com.brianmcmichael.SimpleGlacierUploader.SimpleGlacierUploader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class AddVaultFrame
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    String addCode;
    JTextField jtfAddField;
    JButton jbtAdd;
    JButton jbtBack;
    AmazonGlacierClient addClient;
    int locationChoice;
    String addVault;
    ContextMenuMouseListener rmb = new ContextMenuMouseListener();

    public AddVaultFrame(AmazonGlacierClient client, int region) {
        super("Add Vault");
        AmazonGlacierClient newVaultClient = client;
        int thisRegion = region;
        int width = 200;
        int height = 170;
        Color wc = Color.WHITE;
        this.addClient = client;
        JLabel label1 = new JLabel("Name of Vault to add to " + SimpleGlacierUploader.getRegion(thisRegion) + ":");
        this.jtfAddField = new JTextField(30);
        this.jbtAdd = new JButton("Add");
        this.jbtBack = new JButton("Back");
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(label1);
        p1.setBackground(wc);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.jtfAddField);
        this.jtfAddField.addMouseListener(this.rmb);
        this.jtfAddField.setFocusable(true);
        p2.setBackground(wc);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout());
        p3.add(this.jbtAdd);
        this.jbtAdd.addActionListener(this);
        this.jbtAdd.setBackground(wc);
        p3.add(this.jbtBack);
        this.jbtBack.addActionListener(this);
        this.jbtBack.setBackground(wc);
        p3.setBackground(wc);
        JPanel p4 = new JPanel();
        p4.setLayout(new BorderLayout());
        p4.add((Component)p1, "North");
        p4.add((Component)p2, "Center");
        p4.add((Component)p3, "South");
        this.setContentPane(p4);
        this.pack();
        if (width < this.getWidth()) {
            width = this.getWidth();
        }
        if (height < this.getHeight()) {
            height = this.getHeight();
        }
        this.centerOnScreen(width, height);
        this.jtfAddField.setText("");
        this.jtfAddField.requestFocus();
    }

    public void centerOnScreen(int width, int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - width) / 2;
        int y = (screenSize.height - height) / 2;
        int left = x < 0 ? 0 : x;
        int top = y < 0 ? 0 : y;
        this.setBounds(left, top, width, height);
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
        this.jtfAddField.setText("");
        this.jtfAddField.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbtAdd) {
            if (this.jtfAddField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, "Enter the name of the vault to add.", "Error", 0);
            } else {
                try {
                    String vaultToAdd = this.jtfAddField.getText().trim();
                    CreateVaultRequest cvreq = new CreateVaultRequest(vaultToAdd);
                    CreateVaultResult cvres = new CreateVaultResult();
                    cvres = this.addClient.createVault(cvreq);
                    JOptionPane.showMessageDialog(null, "Added vault successfully.", "Success", 1);
                    this.dispose();
                }
                catch (AmazonServiceException k) {
                    JOptionPane.showMessageDialog(null, "The server returned an error.", "Error", 0);
                }
                catch (AmazonClientException i) {
                    JOptionPane.showMessageDialog(null, "Client Error. Check that all fields are correct. Archive not deleted.", "Error", 0);
                }
                catch (Exception j) {
                    JOptionPane.showMessageDialog(null, "Vault not Added. Unspecified Error.", "Error", 0);
                }
                this.jtfAddField.setText("");
                this.jtfAddField.requestFocus();
            }
        } else if (e.getSource() == this.jbtBack) {
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Please choose a valid action.");
        }
    }
}

