/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.DecisionId;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionState;
import com.amazonaws.services.simpleworkflow.flow.worker.DecisionStateMachineBase;
import com.amazonaws.services.simpleworkflow.model.CancelTimerDecisionAttributes;
import com.amazonaws.services.simpleworkflow.model.Decision;
import com.amazonaws.services.simpleworkflow.model.DecisionType;
import com.amazonaws.services.simpleworkflow.model.HistoryEvent;
import com.amazonaws.services.simpleworkflow.model.StartTimerDecisionAttributes;

class TimerDecisionStateMachine
extends DecisionStateMachineBase {
    private StartTimerDecisionAttributes attributes;
    private boolean canceled;

    public TimerDecisionStateMachine(DecisionId id, StartTimerDecisionAttributes attributes) {
        super(id);
        this.attributes = attributes;
    }

    TimerDecisionStateMachine(DecisionId id, StartTimerDecisionAttributes attributes, DecisionState state) {
        super(id, state);
        this.attributes = attributes;
    }

    public Decision getDecision() {
        switch (this.state) {
            case CREATED: {
                return this.createStartTimerDecision();
            }
            case CANCELED_AFTER_INITIATED: {
                return this.createCancelTimerDecision();
            }
        }
        return null;
    }

    public void handleDecisionTaskStartedEvent() {
        switch (this.state) {
            case CANCELED_AFTER_INITIATED: {
                this.stateHistory.add("handleDecisionTaskStartedEvent");
                this.state = DecisionState.CANCELLATION_DECISION_SENT;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleDecisionTaskStartedEvent();
            }
        }
    }

    public void handleCancellationFailureEvent(HistoryEvent event) {
        switch (this.state) {
            case CANCELLATION_DECISION_SENT: {
                this.stateHistory.add("handleCancellationFailureEvent");
                this.state = DecisionState.INITIATED;
                this.stateHistory.add(this.state.toString());
                break;
            }
            default: {
                super.handleCancellationFailureEvent(event);
            }
        }
    }

    public void cancel(Runnable immediateCancellationCallback) {
        this.canceled = true;
        immediateCancellationCallback.run();
        super.cancel(null);
    }

    public boolean isDone() {
        return this.state == DecisionState.COMPLETED || this.canceled;
    }

    private Decision createCancelTimerDecision() {
        CancelTimerDecisionAttributes tryCancel = new CancelTimerDecisionAttributes();
        tryCancel.setTimerId(this.attributes.getTimerId());
        Decision decision = new Decision();
        decision.setCancelTimerDecisionAttributes(tryCancel);
        decision.setDecisionType(DecisionType.CancelTimer.toString());
        return decision;
    }

    private Decision createStartTimerDecision() {
        Decision decision = new Decision();
        decision.setStartTimerDecisionAttributes(this.attributes);
        decision.setDecisionType(DecisionType.StartTimer.toString());
        return decision;
    }
}

