/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPutAttributesRequestMarshaller
implements Marshaller<Request<BatchPutAttributesRequest>, BatchPutAttributesRequest> {
    @Override
    public Request<BatchPutAttributesRequest> marshall(BatchPutAttributesRequest batchPutAttributesRequest) {
        if (batchPutAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchPutAttributesRequest> request = new DefaultRequest<BatchPutAttributesRequest>(batchPutAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchPutAttributes");
        request.addParameter("Version", "2009-04-15");
        if (batchPutAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(batchPutAttributesRequest.getDomainName()));
        }
        List<ReplaceableItem> itemsList = batchPutAttributesRequest.getItems();
        int itemsListIndex = 1;
        for (ReplaceableItem itemsListValue : itemsList) {
            ReplaceableItem replaceableItemMember = itemsListValue;
            if (replaceableItemMember != null) {
                if (replaceableItemMember.getName() != null) {
                    request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString(replaceableItemMember.getName()));
                }
                List<ReplaceableAttribute> attributesList = replaceableItemMember.getAttributes();
                int attributesListIndex = 1;
                for (ReplaceableAttribute attributesListValue : attributesList) {
                    ReplaceableAttribute replaceableAttributeMember = attributesListValue;
                    if (replaceableAttributeMember != null) {
                        if (replaceableAttributeMember.getName() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString(replaceableAttributeMember.getName()));
                        }
                        if (replaceableAttributeMember.getValue() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString(replaceableAttributeMember.getValue()));
                        }
                        if (replaceableAttributeMember.isReplace() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Replace", StringUtils.fromBoolean(replaceableAttributeMember.isReplace()));
                        }
                    }
                    ++attributesListIndex;
                }
            }
            ++itemsListIndex;
        }
        return request;
    }
}

