/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRepeatableInputStream
extends FilterInputStream {
    private static final Log log = LogFactory.getLog(AbstractRepeatableInputStream.class);
    private long bytesReadPastMarkPoint = 0L;
    private long markPoint = 0L;

    protected AbstractRepeatableInputStream(InputStream in) {
        super(in);
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.markPoint += this.bytesReadPastMarkPoint;
        this.bytesReadPastMarkPoint = 0L;
        if (log.isDebugEnabled()) {
            log.debug("Input stream marked at " + this.markPoint + " bytes");
        }
    }

    protected abstract void reopenWrappedStream() throws IOException;

    public synchronized void reset() throws IOException {
        this.reopenWrappedStream();
        long skipped = 0L;
        for (long toSkip = this.markPoint; toSkip > 0L; toSkip -= skipped) {
            skipped = this.skip(toSkip);
        }
        if (log.isDebugEnabled()) {
            log.debug("Reseting to mark point " + this.markPoint + " after returning " + this.bytesReadPastMarkPoint + " bytes");
        }
        this.bytesReadPastMarkPoint = 0L;
    }

    public int read() throws IOException {
        int byteRead = super.read();
        if (byteRead != -1) {
            ++this.bytesReadPastMarkPoint;
            return byteRead;
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        this.bytesReadPastMarkPoint += (long)count;
        return count;
    }

    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        this.bytesReadPastMarkPoint += skipped;
        return skipped;
    }
}

