/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.Group;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListGroupsForUserResult
implements Serializable {
    private ListWithAutoConstructFlag<Group> groups;
    private Boolean isTruncated;
    private String marker;

    public List<Group> getGroups() {
        if (this.groups == null) {
            this.groups = new ListWithAutoConstructFlag();
            this.groups.setAutoConstruct(true);
        }
        return this.groups;
    }

    public void setGroups(Collection<Group> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
        groupsCopy.addAll(groups);
        this.groups = groupsCopy;
    }

    public ListGroupsForUserResult withGroups(Group ... groups) {
        if (this.getGroups() == null) {
            this.setGroups(new ArrayList<Group>(groups.length));
        }
        for (Group value : groups) {
            this.getGroups().add(value);
        }
        return this;
    }

    public ListGroupsForUserResult withGroups(Collection<Group> groups) {
        if (groups == null) {
            this.groups = null;
        } else {
            ListWithAutoConstructFlag groupsCopy = new ListWithAutoConstructFlag(groups.size());
            groupsCopy.addAll(groups);
            this.groups = groupsCopy;
        }
        return this;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public void setIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public ListGroupsForUserResult withIsTruncated(Boolean isTruncated) {
        this.isTruncated = isTruncated;
        return this;
    }

    public Boolean getIsTruncated() {
        return this.isTruncated;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListGroupsForUserResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: " + this.isTruncated() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : ((Object)this.getGroups()).hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsForUserResult)) {
            return false;
        }
        ListGroupsForUserResult other = (ListGroupsForUserResult)obj;
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !((Object)other.getGroups()).equals(this.getGroups())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

