/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.ActiveTrustedSigners;
import com.amazonaws.services.cloudfront.model.transform.SignerStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveTrustedSignersStaxUnmarshaller
implements Unmarshaller<ActiveTrustedSigners, StaxUnmarshallerContext> {
    private static ActiveTrustedSignersStaxUnmarshaller instance;

    @Override
    public ActiveTrustedSigners unmarshall(StaxUnmarshallerContext context) throws Exception {
        ActiveTrustedSigners activeTrustedSigners = new ActiveTrustedSigners();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return activeTrustedSigners;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    activeTrustedSigners.setEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    activeTrustedSigners.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Items/Signer", targetDepth)) continue;
                activeTrustedSigners.getItems().add(SignerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return activeTrustedSigners;
    }

    public static ActiveTrustedSignersStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ActiveTrustedSignersStaxUnmarshaller();
        }
        return instance;
    }
}

