/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.autoscaling.model.ProcessType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeScalingProcessTypesResult
implements Serializable {
    private ListWithAutoConstructFlag<ProcessType> processes;

    public List<ProcessType> getProcesses() {
        if (this.processes == null) {
            this.processes = new ListWithAutoConstructFlag();
            this.processes.setAutoConstruct(true);
        }
        return this.processes;
    }

    public void setProcesses(Collection<ProcessType> processes) {
        if (processes == null) {
            this.processes = null;
            return;
        }
        ListWithAutoConstructFlag processesCopy = new ListWithAutoConstructFlag(processes.size());
        processesCopy.addAll(processes);
        this.processes = processesCopy;
    }

    public DescribeScalingProcessTypesResult withProcesses(ProcessType ... processes) {
        if (this.getProcesses() == null) {
            this.setProcesses(new ArrayList<ProcessType>(processes.length));
        }
        for (ProcessType value : processes) {
            this.getProcesses().add(value);
        }
        return this;
    }

    public DescribeScalingProcessTypesResult withProcesses(Collection<ProcessType> processes) {
        if (processes == null) {
            this.processes = null;
        } else {
            ListWithAutoConstructFlag processesCopy = new ListWithAutoConstructFlag(processes.size());
            processesCopy.addAll(processes);
            this.processes = processesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProcesses() != null) {
            sb.append("Processes: " + this.getProcesses());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProcesses() == null ? 0 : ((Object)this.getProcesses()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingProcessTypesResult)) {
            return false;
        }
        DescribeScalingProcessTypesResult other = (DescribeScalingProcessTypesResult)obj;
        if (other.getProcesses() == null ^ this.getProcesses() == null) {
            return false;
        }
        return other.getProcesses() == null || ((Object)other.getProcesses()).equals(this.getProcesses());
    }
}

