/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.regions;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionMetadataParser;
import com.amazonaws.util.VersionInfoUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpProtocolParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionUtils {
    private static final String CLOUDFRONT_DISTRO = "http://aws-sdk-configurations.amazonwebservices.com/";
    private static List<Region> regions;
    private static final String REGIONS_FILE_OVERRIDE;
    private static final Log log;

    public static synchronized List<Region> getRegions() {
        if (regions == null) {
            RegionUtils.init();
        }
        return regions;
    }

    public static synchronized List<Region> getRegionsForService(String serviceAbbreviation) {
        LinkedList<Region> regions = new LinkedList<Region>();
        for (Region r : RegionUtils.getRegions()) {
            if (!r.isServiceSupported(serviceAbbreviation)) continue;
            regions.add(r);
        }
        return regions;
    }

    public static Region getRegion(String regionName) {
        for (Region r : RegionUtils.getRegions()) {
            if (!r.getName().equals(regionName)) continue;
            return r;
        }
        return null;
    }

    public static Region getRegionByEndpoint(String endpoint) {
        URI targetEndpointUri = RegionUtils.getUriByEndpoint(endpoint);
        String targetHost = targetEndpointUri.getHost();
        for (Region region : RegionUtils.getRegions()) {
            for (String serviceEndpoint : region.getServiceEndpoints().values()) {
                URI serviceEndpointUrl = RegionUtils.getUriByEndpoint(serviceEndpoint);
                if (!serviceEndpointUrl.getHost().equals(targetHost)) continue;
                return region;
            }
        }
        throw new RuntimeException("No region found with any service for endpoint " + endpoint);
    }

    public static synchronized void init() {
        if (System.getProperty(REGIONS_FILE_OVERRIDE) != null) {
            try {
                RegionUtils.loadRegionsFromOverrideFile();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Couldn't find regions override file specified", e);
            }
        }
        try {
            InputStream regionsFile = RegionUtils.getRegionsFileFromCloudfront();
            RegionUtils.initRegions(regionsFile);
        }
        catch (Exception e) {
            log.warn("Failed to initialize regional endpoints from cloudfront", e);
        }
        if (regions == null) {
            RegionUtils.initSDKRegions();
        }
    }

    private static void loadRegionsFromOverrideFile() throws FileNotFoundException {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
        File regionsFile = new File(System.getProperty(REGIONS_FILE_OVERRIDE));
        FileInputStream override = new FileInputStream(regionsFile);
        RegionUtils.initRegions(override);
    }

    private static void initRegions(InputStream regionsFile) {
        try {
            RegionMetadataParser parser = new RegionMetadataParser();
            regions = parser.parseRegionMetadata(regionsFile);
        }
        catch (Exception e) {
            log.warn("Failed to parse regional endpoints", e);
        }
    }

    private static void initSDKRegions() {
        ClassLoader classLoader = RegionUtils.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("/etc/regions.xml");
        RegionUtils.initRegions(inputStream);
    }

    private static InputStream getRegionsFileFromCloudfront() throws IOException {
        String endpointsUrl = "http://aws-sdk-configurations.amazonwebservices.com/endpoints.xml";
        return RegionUtils.fetchFile(endpointsUrl);
    }

    private static InputStream fetchFile(String url) throws IOException, ClientProtocolException, FileNotFoundException {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(httpClientParams, VersionInfoUtils.getUserAgent());
        DefaultHttpClient httpclient = new DefaultHttpClient(httpClientParams);
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = httpclient.execute(httpget);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            return entity.getContent();
        }
        return null;
    }

    private static URI getUriByEndpoint(String endpoint) {
        URI targetEndpointUri = null;
        try {
            targetEndpointUri = new URI(endpoint);
            if (targetEndpointUri.getHost() == null) {
                targetEndpointUri = new URI("http://" + endpoint);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unable to parse service endpoint: " + e.getMessage());
        }
        return targetEndpointUri;
    }

    static {
        REGIONS_FILE_OVERRIDE = RegionUtils.class.getName() + ".fileOverride";
        log = LogFactory.getLog("com.amazonaws.request");
    }
}

