/*
 * Decompiled with CFR 0.152.
 */
package goslim;

import goslim.CluAnno;
import goslim.CluFCMDriver;
import goslim.CluGeneInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;

public class CluGeneExpList {
    ArrayList geneNames;
    ArrayList mappedGeneNames;
    ArrayList geneNamesDesc;
    ArrayList origMappedGeneNames;
    double[][] geneExp;
    Hashtable goCluster;
    Hashtable origGoCluster;
    CluAnno anno;
    int numInstances;
    int numSamples;
    String[] colNames;
    int expStartCol;

    public CluGeneExpList(CluAnno cluAnno, int n, int n2) {
        this.anno = cluAnno;
        this.geneNames = new ArrayList();
        this.geneNamesDesc = new ArrayList();
        this.mappedGeneNames = new ArrayList();
        this.origMappedGeneNames = new ArrayList();
        this.goCluster = new Hashtable();
        this.origGoCluster = new Hashtable();
        this.numInstances = n;
        this.numSamples = n2;
        this.geneExp = new double[n][n2];
        this.expStartCol = 3;
    }

    public void readGeneExpFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            this.colNames = string2.split("\t");
            bufferedReader.readLine();
            int n = 0;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ArrayList arrayList;
                String string3;
                int n3;
                CluGeneInfo cluGeneInfo;
                if (string2.indexOf("!!") != -1) continue;
                boolean bl = false;
                String[] stringArray = string2.split("\t");
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                if (CluFCMDriver.taxonID.equals("9606")) {
                    int n4 = CluFCMDriver.upm.getNumEntryName(string4);
                    if (n4 > 0) {
                        string4 = CluFCMDriver.upm.getEntryName(string4, 0);
                    }
                    System.out.println(string4);
                }
                if ((cluGeneInfo = this.anno.getGeneInfo(string4)) != null) {
                    this.geneNames.add(cluGeneInfo.getOfficialName());
                } else {
                    this.geneNames.add(string4);
                }
                this.geneNamesDesc.add(string5);
                if (cluGeneInfo != null) {
                    for (n3 = 0; n3 < cluGeneInfo.numBelongsTo(); ++n3) {
                        ArrayList arrayList2;
                        string3 = cluGeneInfo.getGOid(n3);
                        if (this.goCluster.containsKey(string3)) {
                            arrayList = (ArrayList)this.goCluster.get(string3);
                            arrayList.add(cluGeneInfo);
                            arrayList2 = (ArrayList)this.origGoCluster.get(string3);
                            arrayList2.add(cluGeneInfo.getOfficialName());
                            this.origGoCluster.put(string3, arrayList2);
                            this.goCluster.put(string3, arrayList);
                            continue;
                        }
                        arrayList = new ArrayList();
                        arrayList.add(cluGeneInfo);
                        arrayList2 = new ArrayList();
                        arrayList2.add(cluGeneInfo.getOfficialName());
                        this.origGoCluster.put(string3, arrayList2);
                        this.goCluster.put(string3, arrayList);
                    }
                    if (cluGeneInfo.numBelongsTo() > 0) {
                        this.mappedGeneNames.add(string4);
                        this.origMappedGeneNames.add(string4);
                    }
                }
                for (n3 = this.expStartCol; n3 < stringArray.length; ++n3) {
                    string3 = stringArray[n3];
                    if (string3.length() > 0) {
                        arrayList = new Double(string3);
                        this.geneExp[n][n3 - this.expStartCol] = (Double)((Object)arrayList);
                        continue;
                    }
                    bl = true;
                }
                if (bl) {
                    ++n2;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void readGeneExpCDTFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = bufferedReader.readLine();
            this.colNames = string2.split("\t");
            bufferedReader.readLine();
            int n = 0;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ArrayList arrayList;
                Object object;
                int n3;
                if (string2.indexOf("!!") != -1) continue;
                boolean bl = false;
                String[] stringArray = string2.split("\t");
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                CluGeneInfo cluGeneInfo = this.anno.getGeneInfo(string3);
                if (cluGeneInfo != null) {
                    this.geneNames.add(cluGeneInfo.getOfficialName());
                } else {
                    this.geneNames.add(string3);
                }
                this.geneNamesDesc.add(string4);
                if (cluGeneInfo != null) {
                    for (n3 = 0; n3 < cluGeneInfo.numBelongsTo(); ++n3) {
                        String string5 = cluGeneInfo.getGOid(n3);
                        if (this.goCluster.containsKey(string5)) {
                            object = (ArrayList)this.goCluster.get(string5);
                            ((ArrayList)object).add(cluGeneInfo);
                            arrayList = (ArrayList)this.origGoCluster.get(string5);
                            arrayList.add(cluGeneInfo.getOfficialName());
                            this.origGoCluster.put(string5, arrayList);
                            this.goCluster.put(string5, object);
                            continue;
                        }
                        object = new ArrayList();
                        ((ArrayList)object).add(cluGeneInfo);
                        arrayList = new ArrayList();
                        arrayList.add(cluGeneInfo.getOfficialName());
                        this.origGoCluster.put(string5, arrayList);
                        this.goCluster.put(string5, object);
                    }
                    if (cluGeneInfo.numBelongsTo() > 0) {
                        this.mappedGeneNames.add(string3);
                    }
                }
                n3 = 0;
                for (int i = this.expStartCol; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    if (this.colNames[i].length() <= 0) continue;
                    if (((String)object).length() > 0) {
                        arrayList = new Double((String)object);
                        this.geneExp[n][n3] = (Double)((Object)arrayList);
                    } else {
                        bl = true;
                    }
                    ++n3;
                }
                if (bl) {
                    ++n2;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void sampleGenes(String string, double d) {
        Random random = new Random();
        try {
            Object object;
            FileWriter fileWriter = new FileWriter(string);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.println("Performing sampling....");
            int n = 0;
            Enumeration enumeration = this.goCluster.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                object = (ArrayList)this.goCluster.get(string2);
                n += ((ArrayList)object).size();
                ((ArrayList)object).clear();
            }
            printWriter.println("Number of annotations currently used = " + n);
            for (int i = 0; i < this.mappedGeneNames.size(); ++i) {
                object = (String)this.mappedGeneNames.get(i);
                CluGeneInfo cluGeneInfo = this.anno.getGeneInfo((String)object);
                if (cluGeneInfo == null) continue;
                for (int j = 0; j < cluGeneInfo.numBelongsTo(); ++j) {
                    ArrayList arrayList;
                    String string3 = cluGeneInfo.getGOid(j);
                    double d2 = random.nextDouble();
                    if (!(d2 > d)) continue;
                    if (this.goCluster.containsKey(string3)) {
                        arrayList = (ArrayList)this.goCluster.get(string3);
                        arrayList.add(cluGeneInfo);
                        this.goCluster.put(string3, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList();
                    arrayList.add(cluGeneInfo);
                    this.goCluster.put(string3, arrayList);
                }
            }
            n = 0;
            enumeration = this.goCluster.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                object = (ArrayList)this.goCluster.get(string4);
                n += ((ArrayList)object).size();
            }
            printWriter.println("Number of annotations used after sampling = " + n);
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public Hashtable getGOCluster() {
        return this.goCluster;
    }

    public Hashtable getOrigGOCluster() {
        return this.origGoCluster;
    }

    public double[][] geneExp() {
        return this.geneExp;
    }

    public ArrayList getGeneNames() {
        return this.geneNames;
    }

    public ArrayList getMappedGeneNames() {
        return this.mappedGeneNames;
    }

    public int getNumTotalMappedGenes() {
        return this.mappedGeneNames.size();
    }

    public int getNumMappedGenes(String string) {
        int n = 0;
        if (this.goCluster.containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.goCluster.get(string);
            n = arrayList.size();
        }
        return n;
    }

    public int getNumAnnoGenes(String string) {
        int n = this.anno.getNumAnnoGenes(string);
        return n;
    }

    public int getNumTotalAnnoGenes() {
        int n = this.anno.getTotalNumAnnoGenes();
        return n;
    }

    public int getNumMappedClusters() {
        int n = this.goCluster.size();
        return n;
    }

    public int getNumInstances() {
        return this.numInstances;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public String[] getColumnHeaders() {
        return this.colNames;
    }

    public int getExpStartCol() {
        return this.expStartCol;
    }

    public ArrayList getGeneNamesDesc() {
        return this.geneNamesDesc;
    }
}

