/*
 * Decompiled with CFR 0.152.
 */
package goslim;

import goslim.CluAnno;
import goslim.CluFCM;
import goslim.CluGOOnto;
import goslim.CluGOSlimHier;
import goslim.CluGeneExpList;
import goslim.CluHierBuild;
import java.util.ArrayList;
import scripts.CluMemberDistrib;

public class CluFCMmain {
    static String aspect = "P";
    static String ignoreFilename = "ignoreGOTerms.txt";
    static String goTermDir = "./go_files/go_200509-termdb-tables/";
    static String goAnnoFilename = "./annotation/gene_association.sgd-Sep05";
    static String goSlimFilename = "./go_files/goslim_yeast.obo";
    static String evidCodeFilename = "./annotation/evidence_code.txt";
    static String geneExpFilename = "yeastall_public.txt";
    static String subset = "goslim_yeast";
    static String category = "biological_process";
    static String rootGOid = "GO:0008150";
    static int numInstances = 6221;
    static int numSamples = 80;
    static String outFilename = geneExpFilename + "_alpha0.15";
    static double alpha = 0.15;
    static double threshold = 0.05;
    static double minMemValue = 0.2;
    static int numSteps = 20;

    public void run(CluAnno cluAnno) {
        CluGeneExpList cluGeneExpList = new CluGeneExpList(cluAnno, numInstances, numSamples);
        cluGeneExpList.readGeneExpFile("./data/" + geneExpFilename);
        CluFCM cluFCM = new CluFCM(cluGeneExpList, outFilename + ".txt", evidCodeFilename);
        cluFCM.initializeU_eviCode(alpha, minMemValue);
        for (int i = 0; i < numSteps; ++i) {
            System.out.println("-----");
            cluFCM.computeCentroids();
            cluFCM.computeMembershipWithGO();
            cluFCM.computeValidity();
            cluFCM.nextStep();
            System.out.println("Iteration " + i + " is complete.");
        }
        cluFCM.printOptimal();
        cluFCM.printOptimalClusterGene(outFilename + "-multiple.txt", threshold);
        cluFCM.outputMapleTreeFormat(outFilename);
        cluFCM.done();
        CluMemberDistrib cluMemberDistrib = new CluMemberDistrib();
        cluMemberDistrib.readInitMembers(outFilename + ".txt");
        cluMemberDistrib.readMultiMembers(outFilename + "-multiple.txt");
        cluMemberDistrib.countNumClusters();
        cluMemberDistrib.writeStat(outFilename + "-stat.txt");
    }

    public static void main(String[] stringArray) {
        CluGOOnto cluGOOnto = new CluGOOnto(goTermDir);
        ArrayList arrayList = cluGOOnto.getGOTerms();
        int n = cluGOOnto.getIndex(rootGOid);
        CluGOSlimHier cluGOSlimHier = new CluGOSlimHier(goSlimFilename, subset, category);
        cluGOSlimHier.buildHier();
        ArrayList arrayList2 = cluGOSlimHier.getTermsWithParent();
        CluHierBuild cluHierBuild = new CluHierBuild(arrayList, arrayList2);
        cluHierBuild.generateSlim(n, 0);
        CluAnno cluAnno = new CluAnno(aspect, cluGOOnto);
        cluAnno.read(goAnnoFilename);
        CluFCMmain cluFCMmain = new CluFCMmain();
        cluFCMmain.run(cluAnno);
    }
}

