function [WT_amount basal_sig sig] = vary_abund(curr_expt_obj, abund_name, abund_range, params)
%This function varies the abundance of a single protein and returns the
%basal and induced pathway output.

%set the length of the simulations.
for expt_num = 1:length(curr_expt_obj.expt)
    curr_expt_obj.expt{expt_num}{2}.duration=20000;
    curr_expt_obj.expt{expt_num}{2}.num_t=100;
end

%get the wild-type abundance of the protein being considered
WT_amount=NaN;
for i = 1:length(curr_expt_obj.param)
    if isequal(curr_expt_obj.param{i}.name, abund_name)
        WT_amount = curr_expt_obj.param{i}.value;
    end
end
for i = 1:length(curr_expt_obj.params_to_tune)
    if isequal(curr_expt_obj.params_to_tune(i).name, abund_name)
        WT_amount = params(i);
    end
end


sig=[];
basal_sig=[];
%for each abundance to be considered
for param_val_num = 1:length(abund_range)

    %compile BNGL commands to set the parameter values for this particular
    %abundance set
    new_params={};
    for param_num = 1:length(curr_expt_obj.param)
        new_params{param_num} = ['setParameter("' char(curr_expt_obj.param{param_num}.name) '","' ...
                        num2str(curr_expt_obj.param{param_num}.value) '")'];
    end

    %Compile BNGL commands to set the estimated parameters 
    for j = 1:length(curr_expt_obj.params_to_tune)
        if ~isequal(curr_expt_obj.params_to_tune(j).name,'dummy_param')
            new_params{end+1} = ['setParameter("' char(curr_expt_obj.params_to_tune(j).name) '","' ...
                        num2str(params(j)) '")'];
        end
    end

    %add the BNGL command to set the abundance of the protein being varied
    new_params{end+1} = ['setParameter("' abund_name '","' ...
                    num2str(abund_range(param_val_num)) '")'];

    %run the simulaiton
    [sim curr_expt_obj.expt] = sim_expts(curr_expt_obj.model, curr_expt_obj.expt, curr_expt_obj.obs, new_params);

    %get the induced and basal pathway output
    for expt_num = 1:length(sim)
        if isequal(curr_expt_obj.expt{expt_num}{2}.name, '100 nM pheromone')
            data_index = curr_expt_obj.expt{expt_num}{2}.obs{1}.data_index;
            sig(param_val_num) = sim{expt_num}{2}.ts.Data(end,data_index);
        end
    end
    basal_sig(param_val_num) = sim{1}{1}.ts.Data(end,data_index);

end
