function [sim expt] = sim_expts(model, expt, obs, new_params)


%Simulate each experiment in expt
for expt_num = 1:length(expt)

    %Start constructing the contents of a BNGL file to run the simulations
    %for the current experiment.  The first line tells BNG to load the
    %model network file (which was generated in Main_estimate_params.m.
    bngl_contents = {['readFile({file=>"' model.BNGL_fname '.net"})']};

    %Add to the conents of the new BNGL file the BNGL statements that we 
    %previously constructed to assign protein abundances and parameter
    %values.
    for i = 1:length(new_params)
        bngl_contents{end+1} = new_params{i};
    end
    
    %For each part of the current experiment, add the part-specific
    %commands to the BNGL file.
    for expt_part = 1:length(expt{expt_num})
        
            %set protein concentrations and parameters specific to the 
            %current experiment part (for example, setting dose information
            %via G protein activation/deactivation rates).
        for i = 1:length(expt{expt_num}{expt_part}.species.names)
            bngl_contents{end+1} = ['setConcentration("' char(expt{expt_num}{expt_part}.species.names(i)) '","' ...
                            char(expt{expt_num}{expt_part}.species.values{i}) '")'];
        end

        for i = 1:length(expt{expt_num}{expt_part}.param.names)
            bngl_contents{end+1} = ['setParameter("' char(expt{expt_num}{expt_part}.param.names(i)) '","' ...
                            char(expt{expt_num}{expt_part}.param.values{i}) '")'];
        end

        stoptime = expt{expt_num}{expt_part}.duration;

        %add the command to simulate the model for the current part of the
        %experiment
        bngl_contents{end+1} = ['simulate_ode({prefix=>"expt_' num2str(expt_num) '_part_' num2str(expt_part) ' - ' model.fname '"' ...
                                ',t_end=>' num2str(stoptime) ...
                                ',atol=>' num2str(model.AbsoluteTolerance) ...
                                ',rtol=>' num2str(model.RelativeTolerance) ...
                                ',n_steps=>' num2str(expt{expt_num}{expt_part}.num_t) ...
                                ',verbose=>0});'];
        bngl_contents{end+1} = '';

   
    end

    %open a file to write the current experiment BNGL file.
    fid = fopen(['sim - ' model.fname '.bngl'], 'w');
    for line_num = 1:length(bngl_contents)
        fprintf(fid, '%s\n', char(bngl_contents{line_num}));
    end
    fclose(fid);

    %Execute the BNGL file
    [s, w] = system([model.BNG2_path ' "sim - ' model.fname '.bngl"']);

    
    %Here we open the results file generated by the simulations.  There is
    %one simulation results file per part of the current experiment.
    for expt_part = 1:length(expt{expt_num})

        %Construct the results file name and read in the contents of the
        %file.
        data_file_name = ['expt_' num2str(expt_num) '_part_' num2str(expt_part) ' - ' model.fname '.gdat'];
        [tempData,tempHeaders] = tblread([data_file_name]);

        %Store the headings of the columns of the results file in the sim
        %object.
        for i = 1:size(tempHeaders,1)-1
            sim{expt_num}{expt_part}.headers{i} = strtrim(tempHeaders(i+1,:));
        end
        
        %Store the observables from the simulation in the sim object.
        sim{expt_num}{expt_part}.ts = timeseries(tempData(:,2:end), tempData(:,1));

        %Here we figure out which observable in the expt object
        %(expt{}{}.obs{}) corresponds with which column of the simulation
        %results (sim{}{}.ts).  The corresponding column number of 
        %sim{}{}.ts is stored in expt{}{}.obs{}.data_index().
        for expt_obs_num = 1:length(expt{expt_num}{expt_part}.obs)
            expt{expt_num}{expt_part}.obs{expt_obs_num}.data_index = [];

            for header_num = 1:length(sim{expt_num}{expt_part}.headers)

                obs_index = expt{expt_num}{expt_part}.obs{expt_obs_num}.obs_index;
                for k = 1:length(obs{obs_index}.observables)
                    if isequal(obs{obs_index}.observables{k},sim{expt_num}{expt_part}.headers{header_num})
                        expt{expt_num}{expt_part}.obs{expt_obs_num}.data_index(end+1) = header_num;
                    end
                end
            end
        end



    end
   
end


