function [k_new, result] = run_opt(model, expt, obs, params_to_tune, ga_options, new_params)

%If parameters that are being estimated are also being altered during any
%of the experiments, throw a warning.
for expt_num = 1:length(expt)
    for expt_part = 1:length(expt{expt_num})
        for i = 1:length(expt{expt_num}{expt_part}.param.names)
            for j = 1:length(params_to_tune)
                if isequal(expt{expt_num}{expt_part}.param.names{i},params_to_tune(j).name)
                    warning('Parameters altered in expt are being estimated');
                end
            end
        end
    end
end


num_params_to_tune = length(params_to_tune);

lb=zeros(num_params_to_tune,1);
ub=zeros(num_params_to_tune,1);
for i = 1:length(params_to_tune)
    lb(i) = params_to_tune(i).lb;
    ub(i) = params_to_tune(i).ub;
end

    %assign a custom objective function for genetic algorithm
objfcn = @(k) (return_error(k, model, expt, obs, params_to_tune, new_params));

    %run genetic algorithm!
[k_new, fval, exitflag, output, population, scores] = ...
        ga(objfcn, num_params_to_tune, [], [], [], [], lb, ub,[], ga_options);

k_new = k_new(:);
result.fval        = fval;
result.exitflag    = exitflag;           

result.output      = output;
result.generations = output.generations;
result.funccount   = output.funccount;
result.message     = output.message;

result.population  = population;
result.scores      = scores;
