function E = return_error(k, model, expt, obs, params_to_tune, new_params)
%This is the function called by the genetic algorithm to give a score to
%the parameter values in vector k.

%Turn the parameter values in k into BNGL commands to set these parameters.
%These parameter assignments are appended to other BNGL parameter
%assignements (made in Main_estimate_params.m).
for i = 1:length(params_to_tune)
    new_params{end+1} = ['setParameter("' char(params_to_tune(i).name) '","' ...
                    num2str(k(i)) '")'];
end

%Simulate the model given the new parameters
[sim expt] = sim_expts(model, expt, obs, new_params);

%Scale the data to best fit the simulation results, and get the quality of
%fit.
[E data_scale data_shift] = fit_data_to_sim(sim, expt, obs, new_params);

%Combine the mean squared errors for each observable into a single error
E = sqrt(sum(E.^2)/length(E));

