function plot_dynamic_range(fig, num_cols, col, protein_info, data_to_plot)
%This function plots the pathway output, swing and induction ratio vs
%protein abundance for varying one particular protein abundance.


x_limits = [1e1 1e6];
x_ticks = [1e1 1e2 1e3 1e4 1e5 1e6];

% FIRST PLOT BAR FOR WT ABUNDANCE (SO OTHER LINES WILL BE IN FRONT)

x_vals = [protein_info.WT_amount, protein_info.WT_amount];

subplot(3,num_cols,col,'XScale','log','XMinorTick','on','FontSize',10,'FontName','Arial')
box('on');
hold('all');
plot(x_vals, data_to_plot.signal_range, 'b:','LineWidth',2)

subplot(3,num_cols,col+num_cols,'XScale','log','XMinorTick','on','FontSize',10, 'FontName','Arial')
box('on');
hold('all');
plot(x_vals, data_to_plot.swing_range, 'b:','LineWidth',2)

subplot(3,num_cols,col+2*num_cols,'XScale','log','YScale','log','XMinorTick','on','FontSize',10, 'FontName','Arial')
box('on');
hold('all');
plot(x_vals, data_to_plot.IR_range, 'b:','LineWidth',2)



% NOW PLOT BASAL SIGNAL 
subplot(3,num_cols,col)
semilogx(protein_info.abund_range,data_to_plot.signal(1,:),'b--','LineWidth',2);


% FINALLY, PLOT SIGNAL, SWING AND INDUCTION RATIO AND LABEL AXES
subplot(3,num_cols,col)
semilogx(protein_info.abund_range,data_to_plot.signal(2,:),'b','LineWidth',2);
if col == 1
    ylabel('Peak # Fus3-PP per cell','FontSize',10,'FontName','Arial')
end
ylim(data_to_plot.signal_range)
xlim(x_limits)
set(gca,'XTick',x_ticks)


subplot(3,num_cols,col+num_cols)
semilogx(protein_info.abund_range,data_to_plot.swing,'b','LineWidth',2);
if col == 1
    ylabel('Swing (# Fus3-PP/cell)','FontSize',10,'FontName','Arial')
end
ylim(data_to_plot.swing_range)
xlim(x_limits)
set(gca,'XTick',x_ticks)


subplot(3,num_cols,col+2*num_cols)
loglog(protein_info.abund_range,data_to_plot.IR,'b','LineWidth',2);
if col == 1
    ylabel('Induction ratio','FontSize',10, 'FontName','Arial')
end
xlabel(protein_info.x_axis_label,'FontSize',10,'FontName','Arial')
ylim(data_to_plot.IR_range)
xlim(x_limits)
set(gca,'XTick',x_ticks)

