function plot_dose_resp(f1,curr_expt_obj, params, num_rows, row_num, plot_name, num2uM)
%This function plots the dose response data and simulation for one
%experiment.


%set the duration of the simulations to 1000s
for expt_num = 1:length(curr_expt_obj.expt)
    curr_expt_obj.expt{expt_num}{2}.duration=1000;
    curr_expt_obj.expt{expt_num}{2}.num_t=1000;
end

    %compile BNGL commands to set the parameter values for this particular
    %abundance set
new_params={};
for param_num = 1:length(curr_expt_obj.param)
    new_params{param_num} = ['setParameter("' char(curr_expt_obj.param{param_num}.name) '","' ...
                    num2str(curr_expt_obj.param{param_num}.value) '")'];
end

%Compile BNGL commands to set the estimated parameters 
for j = 1:length(curr_expt_obj.params_to_tune)
    if ~isequal(curr_expt_obj.params_to_tune(j).name,'dummy_param')
        new_params{end+1} = ['setParameter("' char(curr_expt_obj.params_to_tune(j).name) '","' ...
                    num2str(params(j)) '")'];
    end
end



% simulate the model
[sim curr_expt_obj.expt] = sim_expts(curr_expt_obj.model, curr_expt_obj.expt, curr_expt_obj.obs, new_params);

% Get scaling for the data for best fit to the simulation results.
% For each observable that has corresponding experimental data there is a
% different set of scaling coefficients.
[F obs_scale obs_shift] = fit_data_to_sim(sim, curr_expt_obj.expt, curr_expt_obj.obs, new_params);

%set the order of colors to be used for the different experiments
c_map = 'rbgmykc';

figure(f1)
%for each experiment 
for expt_num = 1:length(curr_expt_obj.expt)
    %we only care about experiment part 2, which is where we stimulate with
    %pheromone (aka, activate G proteins)
    expt_part = 2;

    %for the two observable
    for obs_num = 1:2

        subplot(num_rows, 2, (row_num-1)*2+(3-obs_num))

        %First plot the data, with error bars
        
        %scale the experimental data
        data_to_plot = (curr_expt_obj.expt{expt_num}{expt_part}.obs{obs_num}.data * obs_scale(obs_num) + obs_shift(obs_num))/num2uM;
        data_error_to_plot = (curr_expt_obj.expt{expt_num}{expt_part}.obs{obs_num}.data_error * obs_scale(obs_num) + obs_shift(obs_num))/num2uM;
        t_data = curr_expt_obj.expt{expt_num}{expt_part}.obs{obs_num}.t_data;

        %create errorbar plots
        errorbar(t_data, data_to_plot, data_error_to_plot,[c_map(expt_num) '.']);
        hold on;

        title([plot_name ' - Objective function value: ' num2str(F(obs_num))]);


        %Then plot the simulated timecourses.

        data_index = curr_expt_obj.expt{expt_num}{expt_part}.obs{obs_num}.data_index;
        sim_to_plot = sum(sim{expt_num}{expt_part}.ts.Data(:,data_index)/num2uM,2);
        t_sim = sim{expt_num}{expt_part}.ts.Time;

        plot(t_sim, sim_to_plot, c_map(expt_num))

        %depending on which observable, change the range of the x-axis
        if obs_num==2
            xlim([0 180])
        else
            xlim([0 1000])
        end
        y_limits=ylim;
        ylim([0 y_limits(2)])

        drawnow;

        xlabel('Time (s)');
        ylabel(curr_expt_obj.obs{obs_num}.name);

    end

end
xlabel('Time (s)');
ylabel(curr_expt_obj.obs{obs_num}.name);
