function [state, options,optchanged] = gaoutputfcn(options,state,flag,model)

%indicate that we are not changing any of the genetica algorithm
%optimization options
optchanged = false;


%For all cases other than initialization, load optimization results data
%file, append the most recent generation's results to the params and score
%matrices, and resave optimization results
switch flag
    case {'iter','interrupt', 'done'}
        load(model.fname, 'params', 'score')
        params(state.Generation,:,:) = state.Population;
        score(state.Generation,:) = state.Score;
        save(model.fname, 'params', 'score', '-append')
end
