function mutationChildren = customMutation(parents, options, nvars, FitnessFcn, state, thisScore, thisPopulation, params_to_tune, MutationFrequency, MutationDistance)

    %store the initial parameter values of the parameters to be mutated
Population_to_mutate=thisPopulation(parents,:);

    %here store the parameters to be mutated (values to be returned)
mutationChildren=thisPopulation(parents,:);


%for each paramter in the population
for param=1:length(params_to_tune)
    
        %grab the upper and lower bounds for this parameter
    lb = params_to_tune(param).lb;
    ub = params_to_tune(param).ub;

        %pick the members of the population to be mutated that will have
        %this particular parameter mutated
    parents_to_mutate = find(rand(1,length(parents))<MutationFrequency(param));
   
        %mutate the parameters
    mutation_multipliers = 10.^(randn(length(parents_to_mutate),1)*MutationDistance);
    mutationChildren(parents_to_mutate,param) = Population_to_mutate(parents_to_mutate,param).*mutation_multipliers;

        %make sure all new parameters are within the parameter limits.  If
        %not, re-mutate until they are within the limits.
    below_lb_parent = find(mutationChildren(:,param)<lb);
    above_ub_parent = find(mutationChildren(:,param)>ub);
    while ~(isempty(below_lb_parent) && isempty(above_ub_parent))
        mutation_multipliers = 10.^(randn(length(below_lb_parent),1)*MutationDistance);
        mutationChildren(below_lb_parent,param) = Population_to_mutate(below_lb_parent,param).*mutation_multipliers;

        mutation_multipliers = 10.^(randn(length(above_ub_parent),1)*MutationDistance);
        mutationChildren(above_ub_parent,param) = Population_to_mutate(above_ub_parent,param).*mutation_multipliers;

        below_lb_parent = find(mutationChildren(:,param)<lb);
        above_ub_parent = find(mutationChildren(:,param)>ub);
    end

end


% The arguments to the function are
% 
% parents — Row vector of parents chosen by the selection function
% 
% options — Options structure
% 
% nvars — Number of variables
% 
% FitnessFcn — Fitness function
% 
% state — Structure containing information about the current generation. The State Structure describes the fields of state.
% 
% thisScore — Vector of scores of the current population
% 
% thisPopulation — Matrix of individuals in the current population
% 
% The function returns mutationChildren—the mutated offspring—as a matrix whose rows correspond to the children. The number of columns of the matrix is Number of variables.
