%%

%***************************************************************
%Note that this must be run in a linux environment, 
%it does not work in Windows due to a bug in BioNetGen
%****************************************************************

%%
close all
clear all
drawnow


%% GA settings
num_param_sets = 500;  %population size
subpopulations = [100 20 100 30 100 50 100];
num_generations = 80;

rand('state', sum(100*clock));


%% Model settings

model.AbsoluteTolerance = 1e-7;
model.RelativeTolerance = 1e-5;

model.BNGL_fname = 'YMC';
model.BNG2_path = 'C:\BioNetGen_2.0.46\Perl2\BNG2.pl';

    %a factor to convert #/cell to uM (and vice versa)
    %this factor assumes a cell volume of 29fL (as does the model)
num2uM = 1e6/(29e-15 * 6.022e23);


%% Initialize the model
% define the bounds on unknown model parameters

unknown_params = { ... %name                               nominal value    lower bound     upper bound
                    'kcat_Ptp_MAPK_PO4',                        1,              1e-2,           10; ...
                    'kcat_Ste11pSpSpTSte5Ste7_pS',              1,              1e-2,           10; ...
                    'kcat_Ste11pSpSpTSte5Ste7pS_pT',            1,              1e-2,            10; ...
                    'kcat_Ste4Ste18Ste5Ste11_pS',               1,              1e-2,            10; ...
                    'kcat_Msg5_MAPK_PO4',                       1,              1e-2,           10; ...
                    'kcat_Ste5Ste7pSpTFus3_pT',                 1,              1e-2,           10; ...
                    'kcat_Ste5Ste7pSpTFus3_pY',                 1,              1e-2,           10; ...
                    'kcat_Ste5Ste7pSpTFus3pT_pY',               1,              1e-2,           10; ...
                    'kcat_Ste5Ste7pSpTFus3pY_pT',               1,              1e-2,           10; ...
                    'kcat_nonspecific_dephosph',                5e-4,           1e-4,         2.5e-3; ...
                    'koff_Ptp_MAPK',                            0.1,            1e-3,           10; ...
                    'koff_Ste4Ste18_Ste5',                      0.1,            1e-3,           10; ...
                    'kon_Msg5_MAPK',                            1,              0.1,            10; ...
                    'kon_Ptp_MAPK',                             1,              0.1,            10; ...
                    'kon_Ste4Ste18_Ste5',                       1,              0.1,            10; ...
                    'kon_Ste5_Ste11',                           1,              0.1,            10; ...
                    'kon_Ste5_Ste7',                            1,              0.1,            10; ...
                    'kon_Ste7_MAPK',                            1,              0.1,            10; ...
                    'Ste11_pS_only_PO4_factor',                 10,             10,            1e4; ...
                    'Ste7_pS_only_PO4_factor',                  10,             10,            1e4; ...
                    };


params_for_fitting_input = { ...            
                    'koff_Gpa1_Ste4_0nM',                       3e-3,           1e-5,           1e-2; ...
                    'koff_Gpa1_Ste4_0_1nM',                     3e-3,           1e-3,           1e0; ...
                    'koff_Gpa1_Ste4_100nM',                     3e-2,           1e-3,           1e0; ...
                    'kbind_Gpa1_Ste4_0nM',                      3e-3,           1e-3,           1e0; ...
                    'kbind_Gpa1_Ste4_0_1nM',                    3e-3,           1e-3,           1e0; ...
                    'kbind_Gpa1_Ste4_100nM',                    3e-3,           1e-4,           1e0; ...
                    };

    %dummy is a parameter used for debugging purposes
dummy = {           'dummy_param',                              1,              0.1,             10};

           
           
            
%% Define the observables to be used in the model

%Fus3-PP
obs{1}.name = 'Fus3pTpY';
obs{1}.observables = {'Fus3pTpY'};
obs{1}.fit_type = 'scale no shift';  %just scale the data, do not apply a baseline shift
obs{1}.data_scale.value = ['return_abund(new_params,''Fus3_num'') * ' num2str(num2uM) ' * 0.5']; %start with scale value=0.5*total_Fus3_concentration
obs{1}.data_scale.lb = ['return_abund(new_params,''Fus3_num'') * ' num2str(num2uM) ' * 0.33'];   %lower bound of scale value=0.33*total_Fus3_concentration
obs{1}.data_scale.ub = ['return_abund(new_params,''Fus3_num'') * ' num2str(num2uM) ' * 0.67'];   %upper bound of scale value=0.67*total_Fus3_concentration

obs{2}.name = 'Ste5 at membrane';
obs{2}.observables = {'Ste4_Ste5'};
obs{2}.fit_type = 'scale and shift'; %apply baseline shift AND scale to the data
obs{2}.data_scale.value = ['return_abund(new_params,''Ste5_num'') * ' num2str(num2uM) ' * 0.5']; %start with scale value=0.5*total_Ste5_concentration
obs{2}.data_scale.lb = ['return_abund(new_params,''Ste5_num'') * ' num2str(num2uM) ' * 0.2'];    %lower bound of scale value=0.2*total_Ste5_concentration
obs{2}.data_scale.ub = ['return_abund(new_params,''Ste5_num'') * ' num2str(num2uM)];             %upper bound of scale value=total_Ste5_concentration
obs{2}.data_shift.value = ['return_abund(new_params,''Ste5_num'') * ' num2str(num2uM) ' * 0.01']; %start with shift value=0.01*total_Ste5_concentration
obs{2}.data_shift.lb = ['0'];                                                                     %lower bound of shift value=0
obs{2}.data_shift.ub = ['return_abund(new_params,''Ste5_num'') * ' num2str(num2uM) ' * 0.02'];    %upper bound of shift value=0.02*total_Ste5_concentration


%% Initialize the experiments
%The first index of 'expt' is the experiment number, representing different
%physical experiments.  The second index of 'expt' is the part of the
%experiment, representing different experimental conditions (for example,
%steady state is part 1, and pheromone added for part 2).  For each part,
%we can specify which model species (expt{}{}.species) or parameters
%(expt{}{}.param) we want to change.  For each part we can also specify
%observed experimental results (expt{}{}.obs{}) which correspond to
%observables in the model (for example, 'Fus3pTpY').  The error of the
%observed experimental results can also be given (for later plotting
%purposes).


%expt 1 - simulate to steady state
expt{1}{1}.name = 'To steady state';
expt{1}{1}.duration = 100000;
expt{1}{1}.species.names = {};
expt{1}{1}.species.values = [];
expt{1}{1}.param.names = {'kbind_Gpa1_Ste4','koff_Gpa1_Ste4'};  %assign these model parameters to be equal to the listed parameters on the next line
expt{1}{1}.param.values = {'kbind_Gpa1_Ste4_0nM','koff_Gpa1_Ste4_0nM'};
expt{1}{1}.num_t = 10;
expt{1}{1}.obs = {};

%expt 1 - Once at SS, add 100nM pheromone
expt{1}{2}.name = '100 nM pheromone';
expt{1}{2}.duration = 1000;
expt{1}{2}.num_t = 500;
expt{1}{2}.species.names = {};
expt{1}{2}.species.values = [];
expt{1}{2}.param.names = {'kbind_Gpa1_Ste4', 'koff_Gpa1_Ste4'}; 
expt{1}{2}.param.values = {'kbind_Gpa1_Ste4_100nM','koff_Gpa1_Ste4_100nM'};
expt{1}{2}.obs{1}.name = 'Fus3pTpY';
expt{1}{2}.obs{1}.t_data = [0, 1, 1.5, 2.5, 3.5, 5, 7, 10, 12.5, 15]*60; %time points in seconds
expt{1}{2}.obs{1}.data = [0.11345455, ...                                %corresponding data, normalized to max of 1
			0.37164963, ...
			0.57861288, ...
			0.76623377, ...
			0.8378005, ...
			0.97071014, ...
			0.91434098, ...
			0.96546007, ...
			0.9231832, ...
			1];
expt{1}{2}.obs{1}.data_error = [0.045876762, ...                        %corresponding data error (standard error)
            0.018061813, ...
            0.041151423, ...
            0.03643465, ...
            0.019224123, ...
            0.023261757, ...
            0.057334347, ...
            0.026576762, ...
            0.019981266, ...
            0.071773418, ...
            ];          
expt{1}{2}.obs{2}.name = 'Ste5 at membrane';
expt{1}{2}.obs{2}.t_data = [0 6 12 18 24 30 36 42 48 54 60 66 72 78 84 90 ...
                             96 102 108 114 120 126 132 138 144 150 156 162 168 174];
expt{1}{2}.obs{2}.data = [ 0, ...
            0.284204966, ...
            0.438457475, ...
            0.528262018, ...
            0.820390914, ...
            0.47649234, ...
            0.771790808, ...
            0.746434231, ...
            0.683042789, ...
            0.916534601, ...
            0.855256207, ...
            0.89276281, ...
            0.941362916, ...
            0.963021659, ...
            0.937665082, ...
            0.980982567, ...
            0.831484416, ...
            0.854199683, ...
            0.863180137, ...
            0.833597464, ...
            0.875330164, ...
            0.779186476, ...
            0.970945589, ...
            0.973058637, ...
            0.751716852, ...
            0.743264659, ...
            0.861067089, ...
            0.849973587, ...
            1, ...
            0.866877971, ...
            ];
expt{1}{2}.obs{2}.data_error = [0, ...
            0.141448494, ...
            0.085482937, ...
            0.058799049, ...
            0.099179186, ...
            0.097053883, ...
            0.072495193, ...
            0.07414823, ...
            0.055729213, ...
            0.103429688, ...
            0.133419968, ...
            0.097526149, ...
            0.075328896, ...
            0.082176968, ...
            0.089969678, ...
            0.104374221, ...
            0.040380137, ...
            0.08005177, ...
            0.0774542, ...
            0.121376651, ...
            0.049825779, ...
            0.210401479, ...
            0.149241416, ...
            0.157977813, ...
            0.085482937, ...
            0.104374221, ...
            0.141920761, ...
            0.106972002, ...
            0.181356577, ...
            0.099651453, ...
            ];

%expt 2 - simulate to steady state
expt{2}{1}.name = 'To steady state';
expt{2}{1}.duration = 100000;
expt{2}{1}.species.names = {};
expt{2}{1}.species.values = [];
expt{2}{1}.param.names = {'kbind_Gpa1_Ste4','koff_Gpa1_Ste4'};
expt{2}{1}.param.values = {'kbind_Gpa1_Ste4_0nM','koff_Gpa1_Ste4_0nM'};
expt{2}{1}.num_t = 10;
expt{2}{1}.obs = {};

%expt 2 - Once at SS, add 0.1nM pheromone
expt{2}{2}.name = '0.1 nM pheromone';
expt{2}{2}.duration = 1000;
expt{2}{2}.num_t = 500;
expt{2}{2}.species.names = {};
expt{2}{2}.species.values = [];
expt{2}{2}.param.names = {'kbind_Gpa1_Ste4', 'koff_Gpa1_Ste4'};
expt{2}{2}.param.values = {'kbind_Gpa1_Ste4_0_1nM','koff_Gpa1_Ste4_0_1nM'};
expt{2}{2}.obs{1}.name = 'Fus3pTpY';
expt{2}{2}.obs{1}.t_data = [0, 1, 1.5, 2.5, 3.5, 5, 7, 10, 15]*60;
expt{2}{2}.obs{1}.data = [0.176834852, ...
			0.329371139, ...
			0.288012747, ...
		 	0.558704616, ...
			0.687680218, ...
			0.624247385, ...
			0.577729277, ...
			0.665405012, ...
			0.624194435];
expt{2}{2}.obs{1}.data_error = [0.038525552, ...
            0.288575862, ...
            0.138961848, ...
            0.171095673, ...
            0.152591642, ...
            0.00214348, ...
            0.082528078, ...
            0.025162381, ...
            0.034410183, ...
            ];          
expt{2}{2}.obs{2}.name = 'Ste5 at membrane';
expt{2}{2}.obs{2}.t_data = [0 6 12 18 24 30 36 42 48 54 60 66 72 78 84 90 ...
                             96 102 108 114 120 126 132 138 144 150 156 162 168 174];
expt{2}{2}.obs{2}.data = [0, ...
            0.021130481, ...
            0.068674062, ...
            0.083465399, ...
            0.096143687, ...
            0.075013207, ...
            0.063391442, ...
            0.046487058, ...
            0.105652404, ...
            0.132065504, ...
            0.019017433, ...
            0.071843634, ...
            0.034865293, ...
            0.061278394, ...
            0.080295827, ...
            0.051769678, ...
            0.048600106, ...
            0.025356577, ...
            0.073956683, ...
            0.087691495, ...
            0.196513471, ...
            0.140517697, ...
            0.141574221, ...
            0.116217644, ...
            0.165874274, ...
            0.117274168, ...
            0.072900158, ...
            0.099313259, ...
            0.150026413, ...
            0.142630745, ...
            ];
expt{2}{2}.obs{2}.data_error = [0, ...
            0.038482409, ...
            0.042330586, ...
            0.02338542, ...
            0.051211199, ...
            0.026049551, ...
            0.044106709, ...
            0.030785843, ...
            0.043810671, ...
            0.039074379, ...
            0.046474908, ...
            0.043810671, ...
            0.028121712, ...
            0.035818172, ...
            0.054467406, ...
            0.049731009, ...
            0.034930164, ...
            0.064235922, ...
            0.043810671, ...
            0.040554464, ...
            0.076372742, ...
            0.052395246, ...
            0.056243423, ...
            0.048250924, ...
            0.027825674, ...
            0.048250924, ...
            0.064235922, ...
            0.040258426, ...
            0.04677084, ...
            0.044994717, ...
            ];

        

%Pair up the observables from obs{} with the observables from
%expt{}{}.obs{}.
for expt_num = 1:length(expt)
    for expt_part = 1:length(expt{expt_num})
        for expt_obs_num = 1:length(expt{expt_num}{expt_part}.obs)
            for obs_num = 1:length(obs)
                if isequal(expt{expt_num}{expt_part}.obs{expt_obs_num}.name,obs{obs_num}.name)
                    expt{expt_num}{expt_part}.obs{expt_obs_num}.obs_index = obs_num;
                end
            end
        end
    end
end
       
        
%% Get protein abundances
% Set the protein abundances to be used during optimization. 
% Estimate different model parameters based on the protein abundance set used.
% Note that our abundanc set is called Benjamin.

% abund_set_name = 'YMC_Gmgm';
abund_set_name = 'YMC';
% abund_set_name = 'YMC_Mdr';
% abund_set_name = 'YMC_Sltr';
% abund_set_name = 'YMC_opt';


if isequal(abund_set_name,'YMC_Gmgm');
    param{1}.name = 'Fus3_num';
    param{1}.value = 8480;
    param{2}.name = 'Msg5_num';
    param{2}.value = 538;
    param{3}.name = 'Ptp_num';
    param{3}.value = 768;
    param{4}.name = 'Ste11_num';
    param{4}.value = 736;
    param{5}.name = 'Ste7_num';
    param{5}.value = 672;
    param{6}.name = 'Ste5_num';
    param{6}.value = 1900;
    param{7}.name = 'Ste4_num';   
    param{7}.value = 2050*0.4';    %only ~40% of Ste4 is at the plasma membrane (Hirschman, De Zutter et al. 1997)
    param{8}.name = 'Kd_Ste5_Fus3';
    param{8}.value = 1;
    param{9}.name = 'Kd_Ste7_MAPK';
    param{9}.value = 0.1;

 
    unknown_params(end+1:end+2,:) = { ... %name             starting value    lower bound     upper bound
                                    'koff_Ste5_Ste11',          0.1,            1e-3,           10; ...
                                    'koff_Ste5_Ste7',           0.1,            1e-3,           10; ...
                                    };
    
    params_to_tune_array = [unknown_params; ...
                            params_for_fitting_input; ...
                            dummy];
    
   num_opt = 2;                     
                        
elseif isequal(abund_set_name,'YMC')
    param{1}.name = 'Fus3_num';
    param{1}.value = 20400;
    param{2}.name = 'Msg5_num';
    param{2}.value = 38;
    param{3}.name = 'Ste11_num';
    param{3}.value = 3500;
    param{4}.name = 'Ste7_num';
    param{4}.value = 920;
    param{5}.name = 'Ste5_num';
    param{5}.value = 480;
    param{6}.name = 'Ste4_num';
    param{6}.value = 2045*0.4;   %only ~40% of Ste4 is at the plasma membrane (Hirschman, De Zutter et al. 1997)
    param{7}.name = 'Kd_Ste5_Fus3';
    param{7}.value = 1;
    param{8}.name = 'Kd_Ste7_MAPK';
    param{8}.value = 0.1;
 
    unknown_params(end+1:end+3,:) = { ... %name             starting value    lower bound     upper bound
                                    'koff_Ste5_Ste11',          0.1,            1e-3,           10; ...
                                    'koff_Ste5_Ste7',           0.1,            1e-3,           10; ...
                                    'Ptp_num',                  1000,           10,             50000; ...
                                    };

    params_to_tune_array = [unknown_params; ...
                            params_for_fitting_input; ...
                            dummy];

    num_opt = 4;                     

elseif isequal(abund_set_name,'YMC_Mdr')
    param{1}.name = 'Fus3_num';
    param{1}.value = 0.179/num2uM;
    param{2}.name = 'Msg5_num';
    param{2}.value = 0.064/num2uM;
    param{3}.name = 'Ptp_num';
    param{3}.value = 0.084/num2uM;
    param{4}.name = 'Ste11_num';
    param{4}.value = 0.039/num2uM;
    param{5}.name = 'Ste7_num';
    param{5}.value = 0.068/num2uM;
    param{6}.name = 'Ste5_num';
    param{6}.value = 0.035/num2uM;
    param{7}.name = 'Kd_Ste5_Ste11';
    param{7}.value = 0.089;
    param{8}.name = 'Kd_Ste5_Ste7';
    param{8}.value = 0.118;
    param{9}.name = 'Kd_Ste5_Fus3';
    param{9}.value = 0.910;
    param{10}.name = 'Kd_Ste7_MAPK';
    param{10}.value = 0.174;

    unknown_params(end+1,:) = { ... %name                   starting value    lower bound     upper bound
                                    'Ste4_num',                 1000,           10,             50000; ...
                                    };

    params_to_tune_array = [unknown_params; ...
                            params_for_fitting_input; ...
                            dummy];
    num_opt = 2;                     
    
elseif isequal(abund_set_name,'YMC_Sltr')
    param{1}.name = 'Fus3_num';
    param{1}.value = 0.066/num2uM;
    param{2}.name = 'Ste11_num';
    param{2}.value = 0.033/num2uM;
    param{3}.name = 'Ste7_num';
    param{3}.value = 0.044/num2uM;
    param{4}.name = 'Ste5_num';
    param{4}.value = 0.034/num2uM;
    param{5}.name = 'Kd_Ste5_Ste11';
    param{5}.value = 0.123;
    param{6}.name = 'Kd_Ste5_Ste7';
    param{6}.value = 0.084;
    param{7}.name = 'Kd_Ste5_Fus3';
    param{7}.value = 1;
    param{8}.name = 'Kd_Ste7_MAPK';
    param{8}.value = 0.111;
    
    unknown_params(end+1:end+3,:) = { ... %name             starting value    lower bound     upper bound
                                    'Ste4_num',                 1000,           10,             50000; ...
                                    'Msg5_num',                 1000,           10,             50000; ...
                                    'Ptp_num',                  1000,           10,             50000; ...
                                    };

    params_to_tune_array = [unknown_params; ...
                            params_for_fitting_input; ...
                            dummy];
    num_opt = 2;                     

elseif isequal(abund_set_name,'YMC_opt')
    param{1}.name = 'Kd_Ste5_Fus3';
    param{1}.value = 1;
    param{2}.name = 'Kd_Ste7_MAPK';
    param{2}.value = 0.1;
    
    Ste4_abunds = [2045 2050];
    Ste5_abunds = [1900 480 0.035/num2uM 0.034/num2uM];
    Ste11_abunds= [736 3500 0.039/num2uM 0.033/num2uM];
    Ste7_abunds = [672 920 0.068/num2uM 0.044/num2uM];
    Fus3_abunds = [8480 20400 0.179/num2uM 0.066/num2uM];
    Msg5_abunds = [538 38 0.064/num2uM];
    Ptp_abunds  = [917 0.084/num2uM];

    unknown_params(end+1:end+9,:) = { ... %name             starting value    lower bound     upper bound
                    'Ste4_num',                 mean(Ste4_abunds),          min(Ste4_abunds)/2,    max(Ste4_abunds)*2; ...
                    'Ste5_num',                 mean(Ste5_abunds),          min(Ste5_abunds)/2,    max(Ste5_abunds)*2; ...
                    'Ste11_num',                mean(Ste11_abunds),         min(Ste11_abunds)/2,   max(Ste11_abunds)*2; ...
                    'Ste7_num',                 mean(Ste7_abunds),          min(Ste7_abunds)/2,    max(Ste7_abunds)*2; ...
                    'Fus3_num',                 mean(Fus3_abunds),          min(Fus3_abunds)/2,    max(Fus3_abunds)*2; ...
                    'Msg5_num',                 mean(Msg5_abunds),          min(Msg5_abunds)/2,    max(Msg5_abunds)*2; ...
                    'Ptp_num',                  mean(Ptp_abunds),           min(Ptp_abunds)/2,     max(Ptp_abunds)*2; ...
                    'koff_Ste5_Ste11',                          0.1,            1e-3,           10; ...
                    'koff_Ste5_Ste7',                           0.1,            1e-3,           10; ...
                    };

    params_to_tune_array = [unknown_params; ...
                            params_for_fitting_input; ...
                            dummy];

    num_opt = 2;                     
                        
end    



%% Initialize the model

%convert the bngl file into a network file.
[s, w] = system([model.BNG2_path ' ' model.BNGL_fname '.bngl']);


% Create a set of BNGL statements to alter the values of the parameters as
% per the param{} array.
new_params={};
for abund_num = 1:length(param)
    new_params{end+1} = ['setParameter("' param{abund_num}.name '","' ...
                    num2str(param{abund_num}.value) '")'];
end
asdsad

for optimization_num = 1:num_opt %run the optimization multiple times (twice)

    %Here we create the initial population of parameter sets for the
    %genetic algorithm.  We select 'repeat_size' values evenly distributed
    %through the log of each paramter's allowable range.  We repeat these
    %values enough times to fill parameter sets (for example, 20 repeats
    %for a population of 500 means 25 instances of each parameter value).
    %These parameter values are shuffled randomly among the different
    %parameter sets in the population.  This is repeated for each parameter
    %being estimated.
    
    
        %get the number of parameters to estimate
    num_params_to_tune = size(params_to_tune_array,1);

        %initialize the initial parameter population to be used during
        %optimization
    InitialPopulation = zeros(num_param_sets,num_params_to_tune);

        %for 
    for i=1:num_params_to_tune
        params_to_tune(i).name = params_to_tune_array{i,1};
        params_to_tune(i).value = params_to_tune_array{i,2};    
        params_to_tune(i).lb = params_to_tune_array{i,3};    
        params_to_tune(i).ub = params_to_tune_array{i,4};        

        repeat_size = 20;
        num_full_repeats = floor(num_param_sets/repeat_size);

        for j = 1:num_full_repeats
            InitialPopulation((j-1)*repeat_size+1:j*repeat_size,i) = logspace(log10(params_to_tune(i).lb), log10(params_to_tune(i).ub), repeat_size)';
        end
        InitialPopulation(num_full_repeats*repeat_size+1:end,i) = logspace(log10(params_to_tune(i).lb), log10(params_to_tune(i).ub), mod(num_param_sets,repeat_size))';
        InitialPopulation(:,i) = InitialPopulation(randperm(num_param_sets),i);
    end

    
        %Set the name of the optimization.  This is used for saving the 
        %data to a file, so it should be unique (hence the numbering of
        %optimizations ('optimization_num').
    model.fname = [abund_set_name ' - ' num2str(optimization_num)];

        %Created the .mat file that will store optimization results.  
    params=[];
    score=[];
    save(model.fname, 'params_to_tune', 'obs', 'param', 'expt', 'model', 'params', 'score');
   

%% Run optimization

        %set mutation rate of 5% per parameter
    MutationFrequency = 0.05*ones(1,num_params_to_tune);
    MutationDistance = 0.5; %mutated parameters are mutated by a factor of  10^(randn*0.5)

        %set my custom mutation function instead of the defaul mutation
        %function
    mutationFcn = @(parents, options, nvars, FitnessFcn, state, thisScore, thisPopulation) ... 
            (customMutation(parents, options, nvars, FitnessFcn, state, thisScore, thisPopulation, params_to_tune, MutationFrequency, MutationDistance));

        %set my custom output function to enable saving of parameters and
        %scores mid optimization
    outputFcn = @(options,state,flag) ...
            (gaoutputfcn(options,state,flag,model));
        
        
    ga_options = gaoptimset( ...
                    'CrossoverFraction', 0.5, ...  %half the population geneterated by crossover (the other half by mutation)
                    'CrossoverFcn', {@crossoverintermediate, 1.5*ones(1,length(params_to_tune))}, ...  %crossover is weighted average of parents (child = parent1 + randn * 1.5 * (parent2 - parents1))
                    'Display', 'iter', ...
                    'PopulationSize', subpopulations, ...
                    'EliteCount', 2, ...        %force best 2 members to be carried on untouched to next generation
                    'FitnessLimit', 0, ...
                    'Generations', num_generations, ...
                    'InitialPopulation', InitialPopulation, ...
                    'MutationFcn', mutationFcn, ... 
                    'OutputFcn', outputFcn, ...
                    'StallGenLimit', Inf, ...
                    'StallTimeLimit', Inf ...
                    );


        %initiate the optimization
    [k_new, result] = run_opt(model, expt, obs, params_to_tune, ga_options, new_params);

    
    save(model.fname, 'result', '-append');

end
