function stiffness=Variance(filen)

dat1=dlmread(filen);
dat=dat1(2:length(dat1(:,1)),:);

figure
subplot(2,1,1)
plot(1:length(dat(:,1)),dat(:,1),'r',1:length(dat(:,1)),dat(:,2),'k')
xlabel('Index')
ylabel('Voltage')
legend('X','Y')
title('Raw Data')

%Calibration factors for ~40mW taken 6/18/07 LA/DCA
xcal=154.22;  %nm/V
ycal=111.77;  %nm/V

nmx=xcal*dat(:,1);
nmy=ycal*dat(:,2);

nmx=nmx-mean(nmx);
nmy=nmy-mean(nmy);

subplot(2,1,2)
plot(1:length(dat(:,1)),nmx,'r',1:length(dat(:,1)),nmy,'k')
xlabel('Index')
ylabel('Voltage')
legend('X','Y')
title('Position')

%Parameters
kb=1.3806503*10^-23; %J/K
T=300; %K

%Stiffness by variance

varx=var(nmx*10^-9);
%kxvar=(kb*T/(varx)*10^3);%pN/nm

vary=var(nmy*10^-9);
%kyvar=(kb*T/(vary)*10^3);%pN/nm

disp(['X variance is: ',num2str(varx), ' m^2'])
disp(['Y variance is: ',num2str(vary), ' m^2'])

%disp(['X stiffness is: ',num2str(kxvar),' pN/nm'])
%disp(['Y stiffness is: ',num2str(kyvar),' pN/nm'])