% 
% mM to gram conversions
% 
mm2gGlu    = 0.18018;     
mm2gAmm    = 0.018038;
percentAmm = 36/132;

%
% dilution rate
%
q   = 0.03;
%
% feed rates for the four cases
%
uu  = [25;25;25;25;25];
vv  = [5;5;5;5;5]*percentAmm; % corrected for actual feed in Tai
%
% growth rate found by Leanne in the literature and verified in DL
% Values of K and L from optimization
%
rv = [0.08;0.46;0.109;0.179;0.289];
K  = 0.8;
% L  = 0.04;
L  = 0.04;

%
% case names
%
experimentCase    = cell(7,1);
experimentCase{1} = '12 degree Glucose limited';
experimentCase{2} = '30 degree Glucose limited';
experimentCase{3} = '15 degree';
experimentCase{4} = '20 degree';
experimentCase{5} = '25 degree';
%
% residual concentrations from Tai et al (2007)
% guessed conc for the temp dependence until we got the lowest SSE value
% changing conc for rA does was negligable compared to changing rG, so we
% just used 63
% 
rG = [2.8;0.3;1.75;0.9;0.5]*mm2gGlu
rA = [65.2;61.3;63;63;63]*mm2gAmm

%
% yields from Tai et al (2007)
%
Y  = [0.07;0.07;0.07;0.07;0.07];
E  = 1./Y;
%
% steady state biomass
%
bioMass = (uu-rG)./E
%
% rate parameters estimated from modeling
%
F = (vv-rA)./bioMass

