% clear all

t0  = 0;     %initial time
t1  = 200;   % final time
x0  = 3;     % initial cell population
y0  = 0;     % initial glut concentration
z0  = 0;     % initial ammonium conc
%
% initial state for use in DE solver.
%
S0  = [x0;y0;z0];
%
% rate constants and problem parameters
%
taiParamsRevised;

for iCase = 1:4;
    
    fp = F(iCase);
    u  = uu(iCase);
    v  = vv(iCase);
    r  = rv(iCase);
  
    
    SData = [bioMass(iCase);rG(iCase);rA(iCase)];
    
    %
    % rate constants into parameter vector
    %
    params = zeros(8,1);
    
    params(1) = q;
    params(2) = u;
    params(3) = v;
    params(5) = fp;
    params(6) = r;
    params(7) = K;
    params(8) = L;
    params(9) = m;
    params(10)= b;
    
    %
    % define function for fixed parameter values
    %
    chemostat_2nutrient_dynamics_params = @(t,S)chemostat_2nutrient_dynamics(t,S,params);
    
    %
    % call the matlab function to solve the DE for us.
    %
    [t,St] = ode45(chemostat_2nutrient_dynamics_params,[t0 t1],S0);
    
    SModel = St(end,:)';
    SSE    = sum((SModel-SData).^2);
    figure
    
    plot(t,St,'LineWidth',3)
    
    legend('cells','glucose','ammo')
    xlabel('time')
    ylabel('states')
    title([experimentCase(iCase),'  SSE = ',num2str(SSE)])
    hold on
    plot([t1;t1;t1],SData,'ko','LineWidth',3)
    hold off
    
end






