#!/bin/bash

default_serv=""
username="beauchamplab"
dipterixPath="/Volumes/PennRAID/BeauchampServe/rave_data"

# generate random string
if [ ! -d "$HOME/rave_modules" ] ; then
  mkdir -p "$HOME/rave_modules"
else
  echo "Found: configuration folder"
fi

if [ -f "$HOME/rave_modules/rave-server-uuid" ] ; then
  echo "Found existing UUID"
  uuid=$(cat "$HOME/rave_modules/rave-server-uuid")
else
  echo "Generating UUID for the first time"
  uuid=$(uuidgen)
  echo $uuid > "$HOME/rave_modules/rave-server-uuid"
fi
echo $uuid

# generate ssh key
if [ ! -f "$HOME/rave_modules/.rave-ssh/id_rsa.pub" ] ; then
  mkdir -p $HOME/rave_modules/.rave-ssh
  echo "I'm creating auto-login file for the first time. Please enter a passphrase to protect your computer."
  ssh-keygen -t rsa -f $HOME/rave_modules/.rave-ssh/id_rsa -N "" <<<y
fi

server=""

ssh_cmd () {
  serv="$1"
  cmd="$2"
  msg=$(ssh -i "$HOME/rave_modules/.rave-ssh/id_rsa" -o ForwardX11=no -l $username -t $serv "$cmd")
  echo "$msg"
}

add_ssh_key () {
  serv="$1"

  if [ ! -z "$serv" ]; then
    echo "Trying IP address: $serv"

    KEY=$(cat "$HOME/rave_modules/.rave-ssh/id_rsa.pub")

    # ssh-copy-id -i "$HOME/rave_modules/.rave-ssh/id_rsa" -o ForwardX11=no $username@$server
    # check if the key exists in the key chain, otherwise do nothing
    ( ssh_cmd "$serv" "if [ -z \"\$(grep \"$KEY\" ~/.ssh/authorized_keys )\" ]; then echo $KEY >> ~/.ssh/authorized_keys; echo key added.; fi;" ) && {
      server="$serv"
    }

  fi
}



# Get server IP from existing registry
if [ -f "$HOME/rave_modules/rave-server-addr" ] ; then
  while IFS='' read -r line; do
    line=$(echo "${line}" | tr -d '[:space:]')
    if [ ! -z "$line" ]; then
      add_ssh_key "$line"
      if [ ! -z "$server" ]; then
        break;
      fi
    fi
  done < "$HOME/rave_modules/rave-server-addr"
fi

# Try the default intranet
if [ -z "$server" ]; then
  if [ ! -z "$server" ]; then
    add_ssh_key "$default_serv"
  fi
fi

# User input
if [ -z "$server" ]; then
  echo "!!! Cannot find the server path. Please enter the server IP/name. A valid IP address should look like xxx.xxx.xxx.xxx. For example, '123.45.156.7'"
  read -p "Please enter the server IP/name: " line
  if [ ! -z "$line" ]; then
    add_ssh_key "$line"
    if [ ! -z "$server" ]; then
      touch "$HOME/rave_modules/rave-server-addr"
      echo $server >> "$HOME/rave_modules/rave-server-addr"
    fi
  fi
fi

if [ -z "$server" ]; then
  echo "No valid server available. Abort."
  exit 1
fi

echo "Reconnecting the server $server to obtain the port..."
msg=$( ssh_cmd "$server" "\"$dipterixPath/generate-port.R\" $uuid" )
# msg=$(ssh -i "$HOME/rave_modules/.rave-ssh/id_rsa" -o ForwardX11=no -l $username -t $server "\"$dipterixPath/generate-port.R\" $uuid")
port=$(echo $msg | grep -o "Obtained rave-server port: \([[:digit:]]\{4,5\}\)" | grep -o "\([[:digit:]]\{4,5\}\)")

# launch browser
py_path=$( (which python3) || (which python) )


(
  sleep 5 ;
  $py_path -m webbrowser -t "http://$server:$port"
) &

echo "Launching the RAVE server at http://$server:$port"
( ssh_cmd $server "\"$dipterixPath/launch_rave.R\" $uuid" ) || {
  echo "Failed to launch the server. Please make sure you shut down all other RAVE servers before running this script."
}

