#num_strands = 42
#num_strands = 12
num_strands = 13
num_zones = 2
num_subzones = num_zones*6

#input_filename = "input.txt"
#output_filename = "out.txt"
#input_filename = "input_toplid.txt"
#output_filename = "out_toplid.txt"
input_filename = "input_bottomlid.txt"
output_filename = "out_bottomlid.txt"

scaffold_filename = "p7308.txt"

barrel_indices = [0, 96, 192, 288, 384, 480, 576, 672, 768, 1040, 1136, 1408, 1504, 1776, 1872, 2144, 2240, 2512, 2608, 2880, 2976, 3072, 3168, 3264, 3360, 3456, 3552, 3648, 3744, 3840, 4112, 4208, 4480, 4576, 4848, 4944, 5216, 5312, 5584, 5680, 5952, 6048]
toplid_indices = [856, 952, 1224, 1320, 1592, 1688, 1960, 2056, 2328, 2424, 2696, 2792]
bottomlid_indices = [3832, 3928, 4024, 4296, 4392, 4664, 4760, 5032, 5128, 5400, 5496, 5768, 5864]

#indices = barrel_indices
#indices = toplid_indices
indices = bottomlid_indices


#
# introduces an oligo crossover between strands 'a' and 'b' in direction 'n', where 'n' = 0, 1, or 2
#

def swap(a, b, n):
    if (a+b)%2 == 0: #insert comprehensive adjaceny check function later
        print "strands cannot be adjacent"
        return
    for token in range (num_zones):
        if a%2 == 0:
            TPP_ra[a][6*token + n*2+1][1] = [b, 6*token + n*2+1]
            TPP_ra[a][6*token + n*2  ][0] = [b, 6*token + n*2  ]
            TPP_ra[b][6*token + n*2  ][1] = [a, 6*token + n*2  ]
            TPP_ra[b][6*token + n*2+1][0] = [a, 6*token + n*2+1]
        else:
            TPP_ra[a][6*token + n*2  ][1] = [b, 6*token + n*2  ]
            TPP_ra[a][6*token + n*2+1][0] = [b, 6*token + n*2+1]
            TPP_ra[b][6*token + n*2+1][1] = [a, 6*token + n*2+1]
            TPP_ra[b][6*token + n*2  ][0] = [a, 6*token + n*2  ]
    return

#
# takes a string and returns its reverse compliment
#

def get_reverse_compliment(string):
	string = get_reverse(string)
	new_string = ""
	for index in range(len(string)):
		if string[index] == 'A' or string[index] == 'a':
			new_string += 'T'
		elif string[index] == 'C' or string[index] == 'c':
			new_string += 'G'
		elif string[index] == 'G' or string[index] == 'g':
			new_string += 'C'
		elif string[index] == 'T' or string[index] == 't':
			new_string += 'A'
	return new_string

#
# get_reverse: returns a string's inversion
#

def get_reverse(string):
	temp = list(string)
	temp.reverse()
	temp = ''.join(temp)
	return temp

#
# create and populate TPP_ra
#

def create_TPP_ra():

	for strand_num in range(num_strands):
		sub_TPP_ra = []
		for token_num in range(num_subzones):
			if strand_num%2 == 0:
				previous_TP = [strand_num, (token_num + 1)%num_subzones]
				if previous_TP[1] == 0:
					previous_TP[1] = -1
				next_TP = [strand_num, (token_num - 1)%num_subzones]
				if next_TP[1] == (num_subzones - 1):
					next_TP[1] = -1
				sub_TPP_ra.append([previous_TP, next_TP])
			else:
				previous_TP = [strand_num, (token_num - 1)%num_subzones]
				if previous_TP[1] == (num_subzones - 1):
					previous_TP[1] = -1
				next_TP = [strand_num, (token_num + 1)%num_subzones]
				if next_TP[1] == 0:
					next_TP[1] = -1
				sub_TPP_ra.append([previous_TP, next_TP])
		TPP_ra.append(sub_TPP_ra)
	return

#
# read in input file and perform oligo crossovers using swap()
#

def read_input_and_swap():

	f = open(input_filename, 'r')
	
	read_flag = 1
	
	while(read_flag):
		a = str(f.read(3))
		if a == "-01":
			read_flag = 0
		else:
			a = int(a)
			f.read(1)
			b = int(f.read(3))
			f.read(1)
			n = int(f.read(1))
			f.read(1)
			if (b-a)%num_strands != 1 or n < 0 or n >= 3:
				print "input file is in incorrect format"
			else:
				swap(a, b, n)

	f.close()
	return

#
# read scaffold into new variable
#

def read_scaffold():

	f = open(scaffold_filename, 'r')
	scaffold = f.readline()
	f.close()
	#future version: insert robustness check for file length
	scaffold = scaffold[:7308] #truncate the last character
	return
	
#
# get_scaffold_token_seq()
# takes a strand number, token number, and list of indices (denotes which part of structure)
# returns the corresponding 5' to 3' scaffold sequence
#


def get_scaffold_token_seq(strand_num, token_num, index_list):
	if strand_num%2 == 0:
		start_slice = index_list[strand_num] + token_num * 7
		return scaffold[start_slice:(start_slice + 7)]
	if strand_num%2 == 1:
		start_slice = index_list[strand_num] + (12 - 1 - token_num) * 7
		return get_reverse(scaffold[start_slice:(start_slice + 7)])
	
#
# create a new token array, set all values to -1 (unvisited)
#

def init_visited_tokens_ra():

	for strand_num in range(num_strands):
		sub_TPP_ra = []
		for token_num in range(num_subzones):
			sub_TPP_ra.append(-1)
		visited_tokens_ra.append(sub_TPP_ra)
	#print 'before navigation'
	#for strand_num in range(num_strands):
	#	for token_num in range(num_subzones):
	#		print ('%03d' % visited_tokens_ra[strand_num][token_num]),
	#	print ''
	return


#
# populate visited_tokens_ra with oligo numbers
#

def assign_oligos():

	token_counter = 0
	
	for strand_num in range(num_strands):
		for token_num in range(num_subzones):
			if visited_tokens_ra[strand_num][token_num] == -1:
				temp_strand_num = strand_num
				temp_token_num = token_num
				while visited_tokens_ra[temp_strand_num][temp_token_num] == -1 and temp_token_num != -1: #traverse backwards
					visited_tokens_ra[temp_strand_num][temp_token_num] = token_counter
					temptemp_strand_num = temp_strand_num
					temptemp_token_num = temp_token_num
					temp_strand_num = TPP_ra[temptemp_strand_num][temptemp_token_num][0][0]
					temp_token_num = TPP_ra[temptemp_strand_num][temptemp_token_num][0][1]
				temp_strand_num = strand_num
				temp_token_num = token_num
				visited_tokens_ra[strand_num][token_num] = -1  #klugy: resets it to -1 just so it will enter the next loop
				while visited_tokens_ra[temp_strand_num][temp_token_num] == -1 and temp_token_num != -1: #traverse forwards
					visited_tokens_ra[temp_strand_num][temp_token_num] = token_counter
					temptemp_strand_num = temp_strand_num
					temptemp_token_num = temp_token_num
					temp_strand_num = TPP_ra[temptemp_strand_num][temptemp_token_num][1][0]
					temp_token_num = TPP_ra[temptemp_strand_num][temptemp_token_num][1][1]
				token_counter += 1
	#print ''
	#print ''
	#for strand_num in range(num_strands):
	#	for token_num in range(num_subzones):
	#		print ('%03d' % visited_tokens_ra[strand_num][token_num]),
	#	print ''
	return

#
# output()
#

def output(f, oligo_info, oligo_sequence, oligo_num):
    checksum = 0
    c = 0
    counter = 0
    block_start = 0
    while c < len(oligo_sequence):
        if c == 0:
            f.write("%2d" % oligo_num)
            f.write("  ")
        elif c % 48 == 0:
            f.write("    ")
        f.write(oligo_info[c:c+8])
        checksum += 1
        counter += 1
        c += 8
        if counter == 6 or c >= len(oligo_sequence):
            f.write("\n")
            f.write("    ")
            f.write(oligo_sequence[block_start:c])
            f.write("\n\n")
            counter = 0
            block_start += 48
#    f.write("%2d" % oligo_num)
#    f.write("  ")
#    counter = 0
#    c = 0
#    while c < len(oligo_sequence):
#        if c != 0 and c%48 == 0:
#            f.write("    ")
#        f.write(oligo_info[c:c+8])
#        counter += 1
#        c += 8
#        if counter == 6 or c >= len(oligo_sequence):
#            f.write("\n")
#            f.write("    ")
#            f.write(oligo_sequence[c:(c + counter*8)])
#            f.write("\n\n")
#            counter = 0
    return checksum

#
# print 5' to 3' "oligo" and corresponding token pointers
# use scaffold conversion function
#

def generate_oligos():

	f = open(output_filename, 'w')
	checksum = 0
	f.write("ol  str tk\n\n") # header
	
	for strand_num in range(num_strands):
		for token_num in range(num_subzones):
			oligo_num = -1
			if visited_tokens_ra[strand_num][token_num] >= 0: # check if visited
				temp_strand_num = strand_num
				temp_token_num = token_num
				start_strand_num = -1 # default
				start_token_num = -1 # default
				while 1 == 1: # traverse to start of oligo
					# if beginning of oligo, or if looped back to start of circular oligo
					if TPP_ra[temp_strand_num][temp_token_num][0][1] == -1 or (TPP_ra[temp_strand_num][temp_token_num][0][0] == strand_num
						and TPP_ra[temp_strand_num][temp_token_num][0][1] == token_num):
						start_strand_num = temp_strand_num
						start_token_num = temp_token_num
						break
					else:
						temptemp_strand_num = temp_strand_num
						temptemp_strand_num = temp_strand_num
						temptemp_token_num = temp_token_num
						temp_strand_num = TPP_ra[temptemp_strand_num][temptemp_token_num][0][0]
						temp_token_num = TPP_ra[temptemp_strand_num][temptemp_token_num][0][1]
				oligo_info = ""
				oligo_sequence = ""
				oligo_num = visited_tokens_ra[temp_strand_num][temp_token_num]
				while 1 == 1: # traverse length of oligo
					oligo_info += "%03d" % temp_strand_num
					oligo_info += " "
					oligo_info += "%02d" % temp_token_num
					oligo_info += "  "
					oligo_sequence += get_reverse_compliment(get_scaffold_token_seq(temp_strand_num, temp_token_num, indices))
					oligo_sequence += " "
					visited_tokens_ra[temp_strand_num][temp_token_num] *= -1 # mark as visited
					visited_tokens_ra[temp_strand_num][temp_token_num] -= 1 # so 000 can still be used
					if TPP_ra[temp_strand_num][temp_token_num][1][1] == -1 or visited_tokens_ra[TPP_ra[temp_strand_num][temp_token_num][1][0]][TPP_ra[temp_strand_num][temp_token_num][1][1]] < 0:
						break
					else: #go to next token
						temptemp_strand_num = temp_strand_num
						temptemp_token_num = temp_token_num
						temp_strand_num = TPP_ra[temptemp_strand_num][temptemp_token_num][1][0]
						temp_token_num = TPP_ra[temptemp_strand_num][temptemp_token_num][1][1]
				# ensure that an oligo isn't chopped right before/after a crossover
				if (start_strand_num + start_token_num) % 2 == 0:
					oligo_info += oligo_info[0:8]
					oligo_info = oligo_info[8:len(oligo_info)]
					oligo_sequence += oligo_sequence[0:8]
					oligo_sequence = oligo_sequence[8:len(oligo_sequence)]                    
				checksum += output(f, oligo_info, oligo_sequence, oligo_num)

	f.write("the checksum is ")
	f.write(str(checksum))
	f.write("\n")
	f.write("the checksum should be ")
	f.write(str(num_subzones*num_strands))
	f.close()
	#print get_scaffold_token_seq(1, 10, barrel_indices)
	return


read_scaffold()

TPP_ra = []
visited_tokens_ra = []
create_TPP_ra()
read_input_and_swap()
init_visited_tokens_ra()
assign_oligos()
generate_oligos()